/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.view102.CustomFader;
import com.softsynth.jsyn.view102.CustomFaderListener;
import compmus.SignalDisplay;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Dimension;

public class SampledFader
extends Applet
implements CustomFaderListener,
Runnable {
    static final int FADER_RANGE = 256;
    static final int QUANTIZED_RANGE = 32;
    static final int CLIP_MARGIN = 6;
    static final int THUMB_MARGIN = 20;
    static final int NUM_SAMPLES = 32;
    static final int QUANTIZED_MAX = 31;
    static final int OVER_RANGE = 44;
    static final int min_WY = -6;
    static final int max_WY = 38;
    CustomFader customFader;
    int[] sampledData;
    SignalDisplay xyplot;
    Thread thread;
    volatile boolean go;
    int currentValue = 16;

    public static void main(String[] args) {
        SampledFader applet = new SampledFader();
        AppletFrame frame = new AppletFrame("SampledFader", applet);
        frame.resize(600, 500);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.sampledData = new int[32];
        this.setLayout(new BorderLayout());
        this.xyplot = new SignalDisplay(this.sampledData, -6.0, 38.0);
        this.add("Center", this.xyplot);
        this.customFader = new CustomFader(1, 256, 10, 0, 256){

            @Override
            public Dimension preferredSize() {
                return new Dimension(40, 100);
            }
        };
        this.calcCurrentValue(256);
        this.customFader.addCustomFaderListener(this);
        this.customFader.setBlockIncrement(10);
        this.customFader.setUnitIncrement(1);
        this.add("East", this.customFader);
        this.getParent().validate();
        this.getToolkit().sync();
        this.go = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void stop() {
        this.removeAll();
        this.go = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (this.go) {
            int[] nArray = this.sampledData;
            // MONITORENTER : this.sampledData
            int i = 0;
            while (true) {
                if (i >= 31) {
                    this.sampledData[31] = this.currentValue;
                    this.xyplot.repaint();
                    // MONITOREXIT : nArray
                    break;
                }
                this.sampledData[i] = this.sampledData[i + 1];
                ++i;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void calcCurrentValue(int value) {
        int val = (256 - value + 20) * 44 / 296 - 6;
        if (val > 31) {
            val = 31;
        } else if (val < 0) {
            val = 0;
        }
        this.currentValue = val;
    }

    @Override
    public void customFaderValueChanged(Object fader, int value) {
        this.calcCurrentValue(value);
    }
}

