/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.jsyn.view11x.DecibelPortFader;
import com.softsynth.jsyn.view11x.PortFader;
import compmus.MultiTapDelayController;
import compmus.VariableMultiTapDelay;
import compmus.XYTheremin;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;

public class MultiTapDelayLab
extends Applet {
    TriangleOscillator mySource;
    LineOut myOut;
    VariableMultiTapDelay myEcho;
    MultiTapDelayController myEditor;
    XYTheremin theremin;

    public static void main(String[] args) {
        MultiTapDelayLab applet = new MultiTapDelayLab();
        AppletFrame frame = new AppletFrame("Test Sample", applet);
        frame.setSize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(250, 250, 250));
        Panel bottomPanel = new Panel();
        bottomPanel.setLayout(new GridLayout(1, 0));
        this.add("South", bottomPanel);
        Panel faderPanel = new Panel();
        faderPanel.setBackground(Color.white);
        faderPanel.setLayout(new GridLayout(0, 1));
        bottomPanel.add(faderPanel);
        try {
            Synth.startEngine(0);
            this.myEcho = new VariableMultiTapDelay(4, 5.0){

                @Override
                public void updateDisplay() {
                    if (MultiTapDelayLab.this.myEditor != null) {
                        MultiTapDelayLab.this.myEditor.repaint();
                    }
                }
            };
            this.myEditor = new MultiTapDelayController(this.myEcho);
            this.myEditor.setBackground(new Color(200, 240, 240));
            this.add("Center", this.myEditor);
            this.mySource = new TriangleOscillator();
            this.myOut = new LineOut();
            this.mySource.output.connect(this.myEcho.input);
            this.mySource.output.connect(0, this.myOut.input, 0);
            this.myEcho.output.connect(0, this.myOut.input, 1);
            this.theremin = new XYTheremin(this.mySource);
            this.theremin.setBackground(new Color(240, 240, 230));
            this.theremin.setSize(120, 120);
            bottomPanel.add(this.theremin);
            this.theremin.start();
            faderPanel.add(new PortFader(this.myEcho.feedback, -0.9, -1.0, 0.0));
            faderPanel.add(new DecibelPortFader(this.myEcho.amplitude, "echo (dB)", -3.0, -60.0, 0.0));
            this.myOut.start();
            this.myEcho.start(Synth.getTickCount() + (int)(Synth.getTickRate() / 4.0));
            this.mySource.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.theremin.stop();
            this.mySource.stop();
            this.myEcho.stop(Synth.getTickCount());
            this.myOut.stop();
            this.removeAll();
            Synth.setTrace(0);
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

