/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.view11x.XYController;
import compmus.VariableMultiTap;
import compmus.VariableMultiTapDelay;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

class MultiTapDelayController
extends XYController {
    private VariableMultiTapDelay multiTap;
    private static final int ovalSize = 12;
    private int tapHit = -1;

    public MultiTapDelayController(VariableMultiTapDelay multiTap) {
        this.multiTap = multiTap;
        this.setMinWorldX(0.1);
        this.setMaxWorldX(multiTap.getMaxDelay());
        this.setMinWorldY(-1.0);
        this.setMaxWorldY(1.0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MultiTapDelayController.this.tapHit = MultiTapDelayController.this.pickTap(e.getX(), e.getY());
                System.out.println("Hit " + MultiTapDelayController.this.tapHit);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MultiTapDelayController.this.tapHit = -1;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                MultiTapDelayController.this.moveTarget(e.getX(), e.getY());
            }
        });
    }

    protected void moveTarget(int x, int y) {
        if (this.tapHit >= 0) {
            VariableMultiTap tap = this.multiTap.getTap(this.tapHit);
            double delay = this.convertGXtoWX(x);
            delay = this.clipWorldX(delay);
            tap.setTargetDelayInSeconds(delay);
            double amp = this.convertGYtoWY(y);
            amp = this.clipWorldY(amp);
            tap.setAmplitude(amp);
        }
    }

    protected int pickTap(int x, int y) {
        int tapHit = -1;
        int numTaps = this.multiTap.getTapCount();
        int i = 0;
        while (i < numTaps) {
            int ypos = this.getYPos(i);
            int xTargetPos = this.getXTargetPos(i);
            if (Math.abs(x - xTargetPos) < 6 && Math.abs(y - ypos) < 6) {
                tapHit = i;
                break;
            }
            ++i;
        }
        return tapHit;
    }

    private int getXPos(int tapIndex) {
        return this.convertWXtoGX(this.multiTap.getTap(tapIndex).getDelay());
    }

    private int getXTargetPos(int tapIndex) {
        return this.convertWXtoGX(this.multiTap.getTap(tapIndex).getTargetDelayInSeconds());
    }

    private int getYPos(int tapIndex) {
        double amp = this.multiTap.getTap(tapIndex).getAmplitude();
        return this.convertWYtoGY(amp);
    }

    @Override
    public void paint(Graphics g) {
        int w = this.bounds().width;
        int h = this.bounds().height;
        g.setColor(this.getForeground());
        g.drawLine(0, h / 2, w, h / 2);
        int numTaps = this.multiTap.getTapCount();
        int i = 0;
        while (i < numTaps) {
            VariableMultiTap tap = this.multiTap.getTap(i);
            int xpos = this.getXPos(i);
            double amp = tap.getAmplitude();
            int ypos = this.convertWYtoGY(amp);
            g.setColor(this.getForeground());
            g.drawLine(xpos, ypos, xpos, h / 2);
            double peak = tap.getPeakVolume();
            if (amp < 0.0) {
                peak = 0.0 - peak;
            }
            int peakHeight = this.convertWYtoGY(peak);
            g.setColor(Color.red);
            g.drawLine(xpos + 1, peakHeight, xpos + 1, h / 2);
            g.drawLine(xpos + 2, peakHeight, xpos + 2, h / 2);
            int xTargetPos = this.getXTargetPos(i);
            g.setColor(Color.orange);
            g.fillOval(xTargetPos - 6, ypos - 6, 12, 12);
            ++i;
        }
    }
}

