/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import compmus.FFT;
import compmus.Samples;
import compmus.SamplesView;
import java.util.Observable;
import java.util.Observer;

class FFTLabController
implements Observer {
    public Samples fReal = new Samples(this.length);
    public Samples fImag = new Samples(this.length);
    public Samples gReal = new Samples(this.length);
    public Samples gImag = new Samples(this.length);
    public Samples gMag = new Samples(this.length);
    public Samples gPhase = new Samples(this.length);
    public SamplesView fRealView;
    public SamplesView fImagView;
    public SamplesView gRealView;
    public SamplesView gImagView;
    public SamplesView gMagView;
    public SamplesView gPhaseView;
    private int length = 32;

    public FFTLabController() {
        this.initSamples();
        this.fReal.addObserver(this);
        this.fImag.addObserver(this);
        this.gReal.addObserver(this);
        this.gImag.addObserver(this);
        this.fRealView = new SamplesView(this.fReal);
        this.fImagView = new SamplesView(this.fImag);
        this.gRealView = new SamplesView(this.gReal);
        this.gImagView = new SamplesView(this.gImag);
        this.gMagView = new SamplesView(this.gMag);
        this.gPhaseView = new SamplesView(this.gPhase);
        this.updateRanges();
    }

    public void updateRanges() {
        this.updateSampleValues(this.fRealView, this.fImagView);
        this.updateSampleValues(this.gRealView, this.gImagView);
        this.gMagView.setSampleValue(this.gMagView.samples.computeMaxMagnitude());
        this.gPhaseView.setSampleValue(this.gPhaseView.samples.computeMaxMagnitude());
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
        this.updateLengths();
        this.initSamples();
        this.updateRanges();
        this.repaintViews();
    }

    public void zeroAll() {
        this.fReal.zero();
        this.fImag.zero();
        this.gReal.zero();
        this.gImag.zero();
        this.gMag.zero();
        this.gPhase.zero();
        this.repaintViews();
    }

    void recalculate(boolean forward) {
        if (forward) {
            this.transform(1, this.fReal, this.fImag, this.gReal, this.gImag);
            this.updateSampleValues(this.gRealView, this.gImagView);
            this.gRealView.repaint();
            this.gImagView.repaint();
        } else {
            this.transform(-1, this.gReal, this.gImag, this.fReal, this.fImag);
            this.updateSampleValues(this.fRealView, this.fImagView);
            this.fRealView.repaint();
            this.fImagView.repaint();
        }
        this.rectangularToPolar(this.gReal, this.gImag, this.gMag, this.gPhase);
        this.gMagView.setSampleValue(this.gMagView.samples.computeMaxMagnitude());
        this.gPhaseView.setSampleValue(this.gPhaseView.samples.computeMaxMagnitude());
        this.gMagView.repaint();
        this.gPhaseView.repaint();
    }

    @Override
    public void update(Observable o, Object arg) {
        Samples s = (Samples)o;
        this.recalculate(s == this.fReal || s == this.fImag);
    }

    private void rectangularToPolar(Samples sar, Samples sai, Samples amplitudes, Samples phases) {
        double[] ar = sar.values;
        double[] ai = sai.values;
        double[] bamp = amplitudes.values;
        double[] bph = phases.values;
        int i = 0;
        while (i < this.length) {
            bamp[i] = Math.sqrt(ar[i] * ar[i] + ai[i] * ai[i]);
            bph[i] = Math.atan2(ar[i], ai[i]);
            ++i;
        }
    }

    private void updateSampleValues(SamplesView realView, SamplesView imagView) {
        double svr = realView.samples.computeMaxMagnitude();
        double svi = imagView.samples.computeMaxMagnitude();
        double sv = Math.max(svr, svi);
        realView.setSampleValue(sv);
        imagView.setSampleValue(sv);
    }

    private void transform(int sign, Samples sar, Samples sai, Samples bar, Samples bai) {
        double[] ar = sar.values;
        double[] ai = sai.values;
        double[] br = bar.values;
        double[] bi = bai.values;
        int i = 0;
        while (i < this.length) {
            br[i] = ar[i];
            bi[i] = ai[i];
            ++i;
        }
        FFT.complexToComplex(sign, this.length, br, bi);
    }

    private void initSamples() {
        this.fReal.values[1] = 1.0;
        this.transform(1, this.fReal, this.fImag, this.gReal, this.gImag);
    }

    private void updateLengths() {
        int length = this.length;
        this.fReal.setLength(length);
        this.fImag.setLength(length);
        this.gReal.setLength(length);
        this.gImag.setLength(length);
        this.gMag.setLength(length);
        this.gPhase.setLength(length);
    }

    private void repaintViews() {
        this.fRealView.repaint();
        this.fImagView.repaint();
        this.gRealView.repaint();
        this.gImagView.repaint();
        this.gMagView.repaint();
        this.gPhaseView.repaint();
    }
}

