/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.webdrum;

import com.transjam.client.Client;
import com.transjam.client.ModelProxy;
import com.transjam.drumbox.TrackModel;
import com.transjam.util.VerboseDataInputStream;
import com.transjam.util.VerboseDataOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class WebTrackProxy
extends ModelProxy {
    public WebTrackProxy(Client pClient, TrackModel pTrackModel, String thingName) throws IOException {
        super(pClient, pTrackModel, thingName);
    }

    @Override
    public String encodeModelData() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        VerboseDataOutputStream dataOut = new VerboseDataOutputStream(bytesOut);
        TrackModel trackModel = (TrackModel)this.getModel();
        int numBeats = trackModel.getNumBeats();
        dataOut.writeInt(numBeats);
        int i = 0;
        while (i < numBeats) {
            dataOut.writeInt(trackModel.getBeatPitch(i));
            dataOut.writeInt(trackModel.getBeatVolume(i));
            ++i;
        }
        dataOut.writeInt(trackModel.getNumBeats());
        dataOut.writeInt(trackModel.getInTimeOf());
        dataOut.writeInt(trackModel.getInstrumentIndex());
        dataOut.writeInt(trackModel.getPitchOffset());
        dataOut.writeBoolean(trackModel.getReversed());
        dataOut.writeInt((int)(trackModel.getVolume() * 1000.0));
        dataOut.writeInt((int)(trackModel.getPan() * 1000.0));
        dataOut.writeInt((int)(trackModel.getProbability() * 1000.0));
        return bytesOut.toString();
    }

    @Override
    public void decodeModelData(String noteInfo) throws IOException {
        VerboseDataInputStream dataIn = new VerboseDataInputStream(new ByteArrayInputStream(noteInfo.getBytes()));
        int numBeats = dataIn.readInt();
        TrackModel trackModel = (TrackModel)this.getModel();
        trackModel.setNumBeats(numBeats);
        int i = 0;
        while (i < numBeats) {
            int pitch = dataIn.readInt();
            int volume = dataIn.readInt();
            trackModel.setBeatVolumePitch(i, volume, pitch);
            ++i;
        }
        trackModel.setNumBeats(dataIn.readInt());
        trackModel.setInTimeOf(dataIn.readInt());
        trackModel.setInstrumentIndex(dataIn.readInt());
        trackModel.setPitchOffset(dataIn.readInt());
        trackModel.setReversed(dataIn.readBoolean());
        trackModel.setVolume((double)dataIn.readInt() * 0.001);
        trackModel.setPan((double)dataIn.readInt() * 0.001);
        trackModel.setProbability((double)dataIn.readInt() * 0.001);
    }
}

