/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.server;

import com.transjam.admin.AdminProtocolWriter;
import com.transjam.admin.ShutdownThread;
import com.transjam.server.ClientTracker;
import com.transjam.server.Server;
import com.transjam.util.TransjamMessage;
import java.io.IOException;
import java.net.Socket;

public class AdminTracker
extends ClientTracker {
    boolean priveledged = false;
    public AdminProtocolWriter adminWriter;
    ShutdownThread shutter;
    int numTries = 0;
    static final int MAX_TRIES = 3;

    public AdminTracker(Server server, int id, Socket socket) throws IOException {
        super(server, id, socket, server.getTimeoutMSec());
        this.setName("sysop");
        this.adminWriter = new AdminProtocolWriter();
    }

    void grantAdmin() throws IOException {
        this.write(this.adminWriter.grantAdmin(this.getUserID()));
    }

    void denyAdmin(String msg) throws IOException {
        this.write(this.adminWriter.denyAdmin(msg));
    }

    void reportMemory() throws IOException {
        int free = (int)Runtime.getRuntime().freeMemory();
        int total = (int)Runtime.getRuntime().totalMemory();
        this.write(this.adminWriter.reportMemory(free, total));
    }

    void reportClients() throws IOException {
        this.write(this.adminWriter.reportClients(this.server.getNumClients(), this.server.acceptedClients, this.server.deniedClients, this.server.getMaxClients(), this.server.numEncounters, this.server.brokenClients, this.server.totalSeconds));
    }

    @Override
    public void processMessage(TransjamMessage message) throws IOException {
        if (message.command.equals("qmem")) {
            this.reportMemory();
        } else if (message.command.equals("qclients")) {
            this.reportClients();
        } else if (message.command.equals("broadcast")) {
            if (this.priveledged) {
                this.server.broadcast(message.content);
            }
        } else if (message.command.equals("shutdown")) {
            if (this.priveledged) {
                this.server.kill();
            }
        } else if (message.command.equals("reqadmin")) {
            String reason = this.server.requestAdminLogin(this, message.content);
            if (reason == null) {
                this.grantAdmin();
                this.priveledged = true;
            } else {
                this.denyAdmin(reason);
                ++this.numTries;
                if (this.numTries >= 3) {
                    this.beginGracefulShutdown();
                }
            }
        } else {
            super.processMessage(message);
        }
    }
}

