/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.examples.basic;

import com.transjam.awt.AppletTester;
import com.transjam.awt.ClientLoginManager;
import com.transjam.client.Client;
import com.transjam.client.ClientAdapter;
import com.transjam.examples.basic.UserTracker;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.IOException;
import java.util.Hashtable;

public class BasicJam
extends Applet {
    private ClientLoginManager helper;
    private Hashtable clientTable;
    private Client client;
    private Scrollbar fader;
    private Panel panel;

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        this.helper = new ClientLoginManager();
        int maxClientsPerRoom = 4;
        this.client = this.helper.connect(this, "basicJam", maxClientsPerRoom);
        if (this.client == null) {
            this.add(new Label("Connection to server failed! Please try again later."));
        } else {
            this.clientTable = new Hashtable();
            this.panel = new Panel();
            this.panel.setLayout(new GridLayout(0, 1));
            this.panel.setFont(new Font("Monospaced", 1, 18));
            this.fader = new Scrollbar(0, 50, 10, 0, 110);
            this.panel.add(this.fader);
            this.fader.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    int value = e.getValue();
                    try {
                        BasicJam.this.client.sendAll(Integer.toString(value));
                    }
                    catch (IOException exc) {
                        System.err.println("Caught: " + exc);
                    }
                }
            });
            this.setupClientListener();
            this.helper.login();
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    void setupClientListener() {
        ClientAdapter clientAdapter = new ClientAdapter(){

            @Override
            public void enteredRoom(String name, int level) throws IOException {
                BasicJam.this.client.requestUserList();
                BasicJam.this.add("Center", BasicJam.this.panel);
                BasicJam.this.validate();
            }

            @Override
            public void exitedRoom(String name, int level) throws IOException {
                BasicJam.this.clientTable.clear();
                BasicJam.this.remove(BasicJam.this.panel);
                BasicJam.this.validate();
            }

            @Override
            public void addedUser(int uid, String name) {
                UserTracker userTracker = new UserTracker(name);
                BasicJam.this.clientTable.put(new Integer(uid), userTracker);
                BasicJam.this.panel.add(userTracker.getLabel());
                BasicJam.this.getParent().validate();
                BasicJam.this.getToolkit().sync();
            }

            @Override
            public void deletedUser(int uid, String text) {
                UserTracker userTracker = (UserTracker)BasicJam.this.clientTable.remove(new Integer(uid));
                if (userTracker != null) {
                    BasicJam.this.panel.remove(userTracker.getLabel());
                    BasicJam.this.getParent().validate();
                    BasicJam.this.getToolkit().sync();
                }
            }

            @Override
            public void sentAll(int uid, String text) throws IOException {
                int value = Integer.parseInt(text);
                UserTracker userTracker = (UserTracker)BasicJam.this.clientTable.get(new Integer(uid));
                if (userTracker != null) {
                    userTracker.setValue(value);
                }
            }
        };
        this.client.addMessageListener(clientAdapter, 2);
    }

    @Override
    public void stop() {
        this.helper.logout();
        this.panel.removeAll();
        this.removeAll();
    }

    public static void main(String[] argv) {
        BasicJam applet = new BasicJam();
        AppletTester.test(applet, 400, 300);
    }
}

