/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.drumbox;

import com.transjam.drumbox.DrumBox;
import com.transjam.drumbox.DrumSynth;
import com.transjam.drumbox.PanFader;
import com.transjam.drumbox.SongDelegate;
import com.transjam.drumbox.SongModel;
import com.transjam.drumbox.TrackModel;
import com.transjam.drumbox.TrackPlayer;
import com.transjam.drumbox.ValueGrid;
import com.transjam.drumbox.ValueGridEvent;
import com.transjam.drumbox.ValueGridListener;
import com.transjam.drumbox.VolumeFader;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;

public class TrackDelegate
extends Panel {
    private SongDelegate songDelegate;
    private TrackModel trackModel;
    private SongModel songModel;
    private DrumSynth drumSynth;
    private TrackPlayer trackPlayer;
    private ValueGrid valueGrid;
    private Panel miscPanel;
    private Button clearButton;
    private Choice insChoices;
    private Choice numBeatsChoice;
    private Choice inTimeChoice;
    private Checkbox reverseBox;
    private Checkbox soloBox;
    private VolumeFader volumeFader;
    private PanFader panFader;
    private PanFader probabilityFader;
    private static final int MIN_BEATS = 2;
    private static final int MAX_OFFSET = 12;
    public static final Color[] enabledVolumeColors = new Color[]{DrumBox.COLOR_OFF, DrumBox.COLOR_QUIET, DrumBox.COLOR_NORMAL, DrumBox.COLOR_LOUD};
    public static Color[] disabledVolumeColors = new Color[enabledVolumeColors.length];

    static {
        int i = 0;
        while (i < enabledVolumeColors.length) {
            Color disCol;
            Color enCol = enabledVolumeColors[i];
            TrackDelegate.disabledVolumeColors[i] = disCol = new Color((60 + enCol.getRed()) / 2, (60 + enCol.getGreen()) / 2, (60 + enCol.getBlue()) / 2);
            ++i;
        }
    }

    public TrackDelegate(int instrumentIndex, SongDelegate pSongDelegate, TrackModel pTrackModel, TrackPlayer pTrackPlayer, DrumSynth pDrumSynth) {
        this.songDelegate = pSongDelegate;
        this.trackModel = pTrackModel;
        this.drumSynth = pDrumSynth;
        this.trackPlayer = pTrackPlayer;
        this.songModel = this.trackModel.getSongModel();
        this.setLayout(new BorderLayout());
        Panel gridPanel = new Panel(new BorderLayout()){
            Insets border;
            {
                this.border = new Insets(4, 10, 0, 10);
            }

            @Override
            public Insets getInsets() {
                return this.border;
            }
        };
        this.valueGrid = new ValueGrid(this.trackModel.getNumPitchLevels(), this.trackModel.getNumBeats(), enabledVolumeColors, disabledVolumeColors, DrumBox.COLOR_CURSOR){

            @Override
            public int getValue(int row, int column) {
                int pRow = TrackDelegate.this.trackModel.getNumPitchLevels() - TrackDelegate.this.trackModel.getBeatPitch(column) - 1;
                if (row != pRow) {
                    return 0;
                }
                return TrackDelegate.this.trackModel.getBeatVolume(column);
            }
        };
        gridPanel.add("Center", this.valueGrid);
        this.add("Center", gridPanel);
        this.valueGrid.setMaxColumns(this.trackModel.getMaxBeats());
        this.valueGrid.addValueGridListener(new ValueGridListener(){
            int newVolume;

            private int calcNewVolume(int newPitch, int beatIndex) {
                int newVolume = TrackDelegate.this.songDelegate.getCurrentVolumeToSet();
                if (newPitch == TrackDelegate.this.trackModel.getBeatPitch(beatIndex) && newVolume == TrackDelegate.this.trackModel.getBeatVolume(beatIndex)) {
                    newVolume = 0;
                }
                return newVolume;
            }

            private void turnOnGrid(boolean calcNewVolume, int row, int column) {
                int newPitch = TrackDelegate.this.trackModel.getNumPitchLevels() - row - 1;
                if (calcNewVolume) {
                    this.newVolume = this.calcNewVolume(newPitch, column);
                }
                TrackDelegate.this.trackModel.setBeatVolumePitch(column, this.newVolume, newPitch);
            }

            @Override
            public void gridDown(ValueGridEvent vge) {
                this.turnOnGrid(true, vge.getRow(), vge.getColumn());
            }

            @Override
            public void gridDragged(ValueGridEvent vge) {
                this.turnOnGrid(false, vge.getRow(), vge.getColumn());
            }

            @Override
            public void gridUp(ValueGridEvent vge) {
            }
        });
        this.valueGrid.setBackground(DrumBox.COLOR_GRID);
        this.miscPanel = new Panel();
        this.add("South", this.miscPanel);
        this.clearButton = new Button("Clear");
        this.miscPanel.add(this.clearButton);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackDelegate.this.trackModel.clear();
            }
        });
        this.insChoices = this.setupInsChoice();
        this.miscPanel.add(this.insChoices);
        this.numBeatsChoice = this.setupBeatsChoice();
        this.miscPanel.add(this.numBeatsChoice);
        this.numBeatsChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Choice choices = (Choice)e.getSource();
                TrackDelegate.this.trackModel.setNumBeats(choices.getSelectedIndex() + 2);
            }
        });
        this.miscPanel.add(new Label("notes in"));
        this.inTimeChoice = this.setupBeatsChoice();
        this.miscPanel.add(this.inTimeChoice);
        this.inTimeChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Choice choices = (Choice)e.getSource();
                TrackDelegate.this.trackModel.setInTimeOf(choices.getSelectedIndex() + 2);
            }
        });
        this.miscPanel.add(new Label("beats"));
        this.reverseBox = new Checkbox("<");
        this.reverseBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TrackDelegate.this.trackModel.setReversed(TrackDelegate.this.reverseBox.getState());
            }
        });
        this.soloBox = new Checkbox("Solo");
        this.miscPanel.add(this.soloBox);
        this.soloBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean isSolo = TrackDelegate.this.soloBox.getState();
                TrackDelegate.this.songDelegate.setTrackSolo(TrackDelegate.this.trackPlayer, isSolo);
                TrackDelegate.this.soloBox.setBackground(isSolo ? Color.orange : null);
            }
        });
        this.volumeFader = new VolumeFader();
        this.miscPanel.add(this.volumeFader);
        this.volumeFader.setBackground(Color.white);
        this.volumeFader.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if ((Integer)arg == 0) {
                    TrackDelegate.this.trackModel.tweakVolume(TrackDelegate.this.volumeFader.getValue());
                } else {
                    TrackDelegate.this.trackModel.setVolume(TrackDelegate.this.volumeFader.getValue());
                }
            }
        });
        this.panFader = new PanFader("L", "R");
        this.miscPanel.add(this.panFader);
        this.panFader.setBackground(Color.white);
        this.panFader.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if ((Integer)arg == 0) {
                    TrackDelegate.this.trackModel.tweakPan(TrackDelegate.this.panFader.getValue() * 2.0 - 1.0);
                } else {
                    TrackDelegate.this.trackModel.setPan(TrackDelegate.this.panFader.getValue() * 2.0 - 1.0);
                }
            }
        });
        this.probabilityFader = new PanFader("N", "Y");
        this.miscPanel.add(this.probabilityFader);
        this.probabilityFader.setBackground(Color.white);
        this.probabilityFader.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if ((Integer)arg == 0) {
                    TrackDelegate.this.trackModel.tweakProbability(TrackDelegate.this.probabilityFader.getValue());
                } else {
                    TrackDelegate.this.trackModel.setProbability(TrackDelegate.this.probabilityFader.getValue());
                }
            }
        });
        this.trackModel.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                TrackDelegate.this.updateTrackModel(o, arg);
            }
        });
        this.trackPlayer.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                TrackDelegate.this.valueGrid.setCursorColumn(TrackDelegate.this.trackPlayer.getBeat());
            }
        });
        this.setDefaultInstrument(instrumentIndex);
        this.validate();
    }

    public TrackModel getTrackModel() {
        return this.trackModel;
    }

    public void setMaxTimeOf(int maxTimeOf) {
        this.valueGrid.setMaxColumns(maxTimeOf * this.trackModel.getNumBeats() / this.trackModel.getInTimeOf());
        this.valueGrid.repaint();
    }

    public void updateTrackModel(Observable o, Object arg) {
        int changed = (Integer)arg;
        switch (changed) {
            case 1: {
                if (this.numBeatsChoice != null) {
                    this.numBeatsChoice.select(this.trackModel.getNumBeats() - 2);
                }
                if (this.inTimeChoice != null) {
                    this.inTimeChoice.select(this.trackModel.getInTimeOf() - 2);
                }
                this.valueGrid.setNumColumns(this.trackModel.getNumBeats());
                this.songDelegate.updateInTimeOf(this);
                break;
            }
            case 0: {
                if (this.insChoices != null) {
                    this.insChoices.select(this.drumSynth.getInstrumentName(this.trackModel.getInstrumentIndex()));
                }
                this.reverseBox.setState(this.trackModel.getReversed());
                this.volumeFader.setValue(this.trackModel.getVolume());
                this.panFader.setValue((this.trackModel.getPan() + 1.0) * 0.5);
                this.probabilityFader.setValue(this.trackModel.getProbability());
                this.drumSynth.setPan(this.trackModel.getInstrumentIndex(), this.trackModel.getPan());
            }
        }
        this.valueGrid.repaint();
    }

    void setDefaultInstrument(int instrumentIndex) {
        int matchIndex = -1;
        int i = 0;
        while (i < this.drumSynth.getNumInstruments()) {
            if (this.drumSynth.isTunable(i)) {
                if (this.trackModel.getNumPitchLevels() > 1) {
                    ++matchIndex;
                }
            } else if (this.trackModel.getNumPitchLevels() <= 1) {
                ++matchIndex;
            }
            if (matchIndex == instrumentIndex) {
                this.trackModel.setDefaultInstrumentIndex(i);
                break;
            }
            ++i;
        }
    }

    Choice setupInsChoice() {
        Choice choices = new Choice();
        choices.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Choice ch = (Choice)e.getSource();
                String insName = ch.getSelectedItem();
                int insIndex = TrackDelegate.this.drumSynth.getInstrumentIndex(insName);
                TrackDelegate.this.trackModel.setInstrumentIndex(insIndex);
            }
        });
        int i = 0;
        while (i < this.drumSynth.getNumInstruments()) {
            boolean isTunable = this.drumSynth.isTunable(i);
            if (this.trackModel.getNumPitchLevels() > 1 && isTunable || this.trackModel.getNumPitchLevels() <= 1 && !isTunable) {
                choices.addItem(this.drumSynth.getInstrumentName(i));
            }
            ++i;
        }
        return choices;
    }

    Choice setupBeatsChoice() {
        Choice choices = new Choice();
        int i = 2;
        while (i < this.trackModel.getMaxBeats() + 1) {
            choices.addItem("" + i);
            ++i;
        }
        return choices;
    }

    public Panel getMiscPanel() {
        return this.miscPanel;
    }

    @Override
    public void setEnabled(boolean flag) {
        this.valueGrid.setEnabled(flag);
        this.clearButton.setEnabled(flag);
        this.insChoices.setEnabled(flag);
        this.numBeatsChoice.setEnabled(flag);
        this.inTimeChoice.setEnabled(flag);
        this.reverseBox.setEnabled(flag);
        this.volumeFader.setEnabled(flag);
        this.panFader.setEnabled(flag);
        this.probabilityFader.setEnabled(flag);
    }
}

