/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.drumbox;

import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthMixer;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.util.BussedVoiceAllocator;
import com.softsynth.jsyn.view11x.UsageDisplay;
import com.transjam.drumbox.DrumSynth;
import com.transjam.drumbox.WAVRecorder;
import java.awt.Panel;
import java.util.Enumeration;
import java.util.Vector;

public class JSynDrumSynth
implements DrumSynth {
    String recordedFilename = null;
    static final double FRAME_RATE = 44100.0;
    WAVRecorder recorder = null;
    Vector instruments;
    LineOut lineOut;
    SynthMixer mixer;
    DrumVoiceAllocator[] allocators;
    double advanceTime = 0.2;
    Panel synthPanel;
    static final int MAX_VOICES_PER_DRUM = 4;
    int numNullReports = 0;

    @Override
    public synchronized void init() {
        Synth.initialize();
        this.instruments = new Vector();
        try {
            this.instruments.addElement(new InstrumentFactory("DrumWoodFM", "com.transjam.drumbox.DrumWoodFM", 2.0));
            this.instruments.addElement(new InstrumentFactory("KickDrum", "com.transjam.drumbox.SampleKickDrum22K", 1.0));
            this.instruments.addElement(new InstrumentFactory("Timbale", "com.transjam.drumbox.SampleTimbale22K", 1.0));
            this.instruments.addElement(new InstrumentFactory("Snare", "com.transjam.drumbox.SampleSnare22K", 1.0));
            this.instruments.addElement(new InstrumentFactory("RedBurst", "com.transjam.drumbox.RedBurst", 8.0));
            this.instruments.addElement(new InstrumentFactory("CowBell", "com.transjam.drumbox.SampleCowbell22K", 1.0));
            this.instruments.addElement(new InstrumentFactory("OpenHat", "com.transjam.drumbox.OpenHat", 4.0));
            this.instruments.addElement(new InstrumentFactory("WoodBlock", "com.transjam.drumbox.DrumWoodFM", 8.0));
            this.instruments.addElement(new InstrumentFactory("Zoop", "com.transjam.drumbox.Zoop", 8.0));
            this.instruments.addElement(new InstrumentFactory("Claps", "com.transjam.drumbox.HandClaps", 1.0));
            this.instruments.addElement(new InstrumentFactory("SweepUp", "com.transjam.drumbox.SweepUp", 2.0));
            this.instruments.addElement(new InstrumentFactory("PluckedGong", "com.transjam.drumbox.PluckedGong", 1.0));
            this.instruments.addElement(new InstrumentFactory("DrumLowFM", "com.transjam.drumbox.DrumWoodFM", 1.0));
            this.instruments.addElement(new InstrumentFactory("LowBellFM", "com.transjam.drumbox.SimpleBellFM", 1.0));
            this.instruments.addElement(new InstrumentFactory("RingModBell", "com.softsynth.jsyn.circuits.RingModBell", 8.0));
            this.instruments.addElement(new InstrumentFactory("HighBellFM", "com.transjam.drumbox.SimpleBellFM", 4.0));
            this.instruments.addElement(new InstrumentFactory("Sonar", "com.transjam.drumbox.SonarPulse", 6.0));
            this.instruments.addElement(new InstrumentFactory("Bass3Op", "com.transjam.drumbox.BassDrumFM", 0.5));
            this.instruments.addElement(new InstrumentFactory("Fwump", "com.transjam.drumbox.Fwump", 1.0, true));
            this.instruments.addElement(new InstrumentFactory("PulseLead", "com.transjam.drumbox.PulseLead", 2.0, true));
            this.instruments.addElement(new InstrumentFactory("SawBL", "com.softsynth.jsyn.circuits.FilteredSawtoothBL", 1.0, true));
            this.instruments.addElement(new InstrumentFactory("Chebyshev", "com.transjam.drumbox.ChebyshevOsc", 1.0, true));
            this.instruments.addElement(new InstrumentFactory("SineCubedWah", "com.transjam.drumbox.SineCubedWah", 2.0, true));
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
        }
        this.mixer = new SynthMixer(this.getNumInstruments(), 2);
        this.lineOut = new LineOut();
        this.mixer.connectOutput(0, this.lineOut.input, 0);
        this.mixer.connectOutput(1, this.lineOut.input, 1);
        this.allocators = new DrumVoiceAllocator[this.getNumInstruments()];
        int i = 0;
        while (i < this.getNumInstruments()) {
            this.allocators[i] = new DrumVoiceAllocator(4, i);
            this.mixer.connectInput(i, this.allocators[i].getOutput(), 0);
            this.setPan(i, 0.0);
            ++i;
        }
        if (this.recordedFilename != null) {
            this.recorder = new WAVRecorder();
            this.recorder.open(this.recordedFilename, 2, 44100);
            this.mixer.connectOutput(0, this.recorder.input, 0);
            this.mixer.connectOutput(1, this.recorder.input, 1);
        }
    }

    @Override
    public void start() {
        Synth.start(0, 44100.0);
        this.mixer.start();
        this.lineOut.start();
        if (this.recorder != null) {
            this.recorder.start();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.recorder != null) {
            this.recorder.stop();
        }
        this.mixer.stop();
        this.lineOut.stop();
        Synth.stop();
    }

    @Override
    public synchronized void term() {
        if (this.recorder != null) {
            this.recorder.close();
        }
        this.mixer.delete();
        this.lineOut.delete();
        int i = 0;
        while (i < this.getNumInstruments()) {
            this.allocators[i].clear();
            this.allocators[i].delete();
            this.allocators[i] = null;
            ++i;
        }
        this.instruments.removeAllElements();
        Synth.terminate();
    }

    @Override
    public void setPan(int insIndex, double pan) {
        double rightGain = (pan + 1.0) * 0.5;
        double leftGain = 1.0 - rightGain;
        this.mixer.setGain(insIndex, 0, leftGain);
        this.mixer.setGain(insIndex, 1, rightGain);
    }

    @Override
    public int getNumInstruments() {
        if (this.instruments == null) {
            return 0;
        }
        return this.instruments.size();
    }

    @Override
    public String getInstrumentName(int insIndex) {
        return ((InstrumentFactory)this.instruments.elementAt(insIndex)).getName();
    }

    @Override
    public boolean isTunable(int insIndex) {
        return ((InstrumentFactory)this.instruments.elementAt(insIndex)).isTunable();
    }

    @Override
    public int getInstrumentIndex(String insName) {
        int insIndex = -1;
        int i = 0;
        Enumeration enumer = this.instruments.elements();
        while (enumer.hasMoreElements()) {
            InstrumentFactory ins = (InstrumentFactory)enumer.nextElement();
            if (ins.getName().equals(insName)) {
                insIndex = i;
                break;
            }
            ++i;
        }
        return insIndex;
    }

    int secondsToTicks(double seconds) {
        return (int)(Synth.getTickRate() * seconds);
    }

    @Override
    public void hit(double time, double duration, int insIndex, double frequency, double amplitude) {
        try {
            int doneTick;
            SynthNote voice;
            int onTick = this.secondsToTicks(time);
            int durTicks = this.secondsToTicks(duration);
            if (durTicks == 0) {
                durTicks = 1;
            }
            if ((voice = (SynthNote)this.allocators[insIndex].steal(onTick, doneTick = onTick + durTicks * 2 - 1)) != null) {
                double freq = frequency * ((InstrumentFactory)this.instruments.elementAt(insIndex)).getTranspose();
                voice.noteOn(onTick, freq, amplitude);
                int offTick = onTick + (durTicks >> 1);
                voice.noteOff(offTick);
            } else if (this.numNullReports++ < 10) {
                System.err.println("JSynDrumSynth: allocator returned null at time " + onTick);
            }
        }
        catch (SynthException e) {
            SynthAlert.showError(e);
        }
    }

    @Override
    public double getTime() {
        return (double)Synth.getTickCount() / Synth.getTickRate();
    }

    @Override
    public void sleepUntilTime(double time) throws InterruptedException {
        try {
            Synth.sleepUntilTick(this.secondsToTicks(time - this.advanceTime));
        }
        catch (SynthException e) {
            SynthAlert.showError(e);
        }
    }

    @Override
    public Panel getPanel() {
        if (this.synthPanel == null) {
            this.synthPanel = new Panel();
            this.synthPanel.add(new UsageDisplay());
        }
        return this.synthPanel;
    }

    public static void main(String[] args) {
        JSynDrumSynth synth = new JSynDrumSynth();
        double time = synth.getTime();
        int i = 0;
        while (i < 10) {
            System.out.println("Time = " + time);
            time += 5.0;
            try {
                synth.sleepUntilTime(time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
    }

    class DrumVoiceAllocator
    extends BussedVoiceAllocator {
        int insIndex;

        public DrumVoiceAllocator(int maxVoices, int pInsIndex) {
            super(maxVoices);
            this.insIndex = pInsIndex;
        }

        @Override
        public SynthCircuit makeVoice() throws SynthException {
            SynthNote circ = null;
            try {
                circ = ((InstrumentFactory)JSynDrumSynth.this.instruments.elementAt(this.insIndex)).makeVoice();
            }
            catch (IllegalAccessException e) {
                throw new SynthException(e.toString());
            }
            catch (InstantiationException e) {
                throw new SynthException(e.toString());
            }
            return this.addVoiceToMix(circ);
        }
    }

    class InstrumentFactory {
        private String name;
        private Class drumClass;
        private double transpose = 1.0;
        private boolean tunable = false;

        public InstrumentFactory(String pName, String pClassName) throws ClassNotFoundException {
            this.name = pName;
            this.drumClass = Class.forName(pClassName);
        }

        public InstrumentFactory(String pName, String pClassName, double pTranspose) throws ClassNotFoundException {
            this(pName, pClassName);
            this.transpose = pTranspose;
        }

        public InstrumentFactory(String pName, String pClassName, double pTranspose, boolean pTunable) throws ClassNotFoundException {
            this(pName, pClassName, pTranspose);
            this.tunable = pTunable;
        }

        public String getName() {
            return this.name;
        }

        public SynthNote makeVoice() throws InstantiationException, IllegalAccessException {
            return (SynthNote)this.drumClass.newInstance();
        }

        public boolean isTunable() {
            return this.tunable;
        }

        public double getTranspose() {
            return this.transpose;
        }
    }
}

