/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import com.syntona.gui.patch.JackPartner;
import com.syntona.model.SyntonaExporter;
import com.syntona.model.SyntonaSaver;
import com.syntona.plugin.ConnectionHandler;
import com.syntona.plugin.InputJack;
import com.syntona.plugin.JackEditor;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.OutputJack;
import com.syntona.plugin.PatchMessage;
import com.syntona.plugin.SyntonaModel;
import com.syntona.plugin.SyntonaModule;
import java.awt.Color;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Element;

public abstract class Jack
extends SyntonaModel {
    SyntonaModule owner;
    private CopyOnWriteArrayList<Jack> connected = new CopyOnWriteArrayList();
    private JackPartner partner;
    private Vector<ChangeListener> changeListeners;
    private final ChangeEvent changeEvent;
    private Logger logger = Logger.getLogger(Jack.class.getName());
    private boolean visible = true;
    private ConnectionHandler connectionHandler;

    public Jack(SyntonaModule owner, String name, String help) {
        super(name, help);
        this.owner = owner;
        this.changeEvent = new ChangeEvent(this);
        this.changeListeners = new Vector();
        owner.addJack(this);
    }

    public void loadContents(Element jackElement) {
    }

    public void save(SyntonaSaver saver) {
        saver.beginElement("jack");
        saver.addAttribute("name", this.name);
        saver.endElement();
    }

    public abstract void passMessage(PatchMessage var1);

    public boolean willAccept(Jack other) {
        if (this.isConnected(other)) {
            return false;
        }
        return other.isOutput() != this.isOutput();
    }

    public abstract boolean isOutput();

    private boolean isConnected(Jack other) {
        return this.connected.contains(other);
    }

    public void addConnection(Jack other) {
        this.connected.add(other);
    }

    public void removeConnection(Jack other) {
        this.connected.remove(other);
    }

    public void connect(Jack other) {
        this.logger.fine("Connect " + this + " to " + other);
        if (this.willAccept(other) && other.willAccept(this)) {
            this.addConnection(other);
            other.addConnection(this);
            if (this.connectionHandler != null) {
                this.connectionHandler.connectedTo((OutputJack)this, (InputJack)other);
            }
        }
    }

    public void setConnectionHandler(ConnectionHandler handler) {
        this.connectionHandler = handler;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void fireChangeListeners() {
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(this.changeEvent);
        }
    }

    public int getConnectedCount() {
        return this.connected.size();
    }

    public Iterator<Jack> getConnected() {
        return this.connected.iterator();
    }

    public SyntonaModule getModule() {
        return this.owner;
    }

    public Jack getConnected(int i) {
        return this.connected.get(i);
    }

    public void disconnect(Jack other) {
        this.removeConnection(other);
        other.removeConnection(this);
    }

    public JackPartner getPartner() {
        return this.partner;
    }

    public void setPartner(JackPartner partner) {
        this.partner = partner;
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void disconnect() {
        Jack[] jacks;
        Jack[] jackArray = jacks = this.connected.toArray(new Jack[0]);
        int n = jacks.length;
        int n2 = 0;
        while (n2 < n) {
            Jack otherJack = jackArray[n2];
            this.disconnect(otherJack);
            ++n2;
        }
    }

    public String getValueText() {
        return "?";
    }

    public JackEditor getEditor(ModulePresenter modulePresenter) {
        return null;
    }

    public Color getColor() {
        return Color.WHITE;
    }

    public Color getSignalColor() {
        return Color.BLACK;
    }

    public void exportJavaSource(SyntonaExporter exporter, int phase) {
    }

    public void setVisible(boolean flag) {
        this.visible = flag;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ", " + this.getName();
    }
}

