/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.SynthDistributor;
import com.softsynth.jsyn.SynthEnvelopeQueue;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthPort;
import com.softsynth.jsyn.SynthSampleQueue;
import com.softsynth.jsyn.SynthSound;
import com.softsynth.jsyn.SynthVariable;
import com.softsynth.util.IndentingWriter;
import com.softsynth.wire.EnvelopeQueueWireJack;
import com.softsynth.wire.InputSynthWireJack;
import com.softsynth.wire.Module;
import com.softsynth.wire.ObjectExaminer;
import com.softsynth.wire.OutputSynthWireJack;
import com.softsynth.wire.SampleQueueWireJack;
import com.softsynth.wire.SynthWireJack;
import com.softsynth.wire.VariableSynthWireJack;
import com.softsynth.wire.Wire;
import java.io.IOException;

class UnitModule
extends Module {
    SynthSound sound;

    public UnitModule(SynthSound sound) {
        this.sound = sound;
    }

    @Override
    public void start() {
        if (this.sound != null) {
            this.sound.start();
        }
    }

    @Override
    public void stop() {
        if (this.sound != null) {
            this.sound.stop();
        }
    }

    @Override
    boolean delete() {
        boolean cancelled = super.delete();
        if (!cancelled && this.sound != null) {
            this.sound.delete();
        }
        return cancelled;
    }

    @Override
    public void setupJacks() {
        int j;
        String fieldName;
        SynthPort port;
        SynthWireJack wjack;
        int i = 0;
        while (i < this.sound.getNumPorts()) {
            wjack = null;
            port = this.sound.getPortAt(i);
            fieldName = ObjectExaminer.findFieldName(this.sound, port);
            j = 0;
            while (j < port.getNumParts()) {
                wjack = port instanceof SynthInput ? new InputSynthWireJack((Module)this, fieldName, port) : (port instanceof SynthDistributor ? new InputSynthWireJack((Module)this, fieldName, port) : (port instanceof SynthVariable ? new VariableSynthWireJack((Module)this, fieldName, port) : (port instanceof SynthEnvelopeQueue ? new EnvelopeQueueWireJack((Module)this, fieldName, port) : (port instanceof SynthSampleQueue ? new SampleQueueWireJack((Module)this, fieldName, port) : null))));
                if (wjack != null) {
                    wjack.setPartIndex(j);
                    this.addJackCanvas(wjack);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.sound.getNumPorts()) {
            wjack = null;
            port = this.sound.getPortAt(i);
            fieldName = ObjectExaminer.findFieldName(this.sound, port);
            j = 0;
            while (j < port.getNumParts()) {
                wjack = port instanceof SynthOutput ? new OutputSynthWireJack((Module)this, fieldName, port) : null;
                if (wjack != null) {
                    wjack.setPartIndex(j);
                    this.addJackCanvas(wjack);
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void generateSource(IndentingWriter writer, int phase) throws IOException {
        super.generateSource(writer, phase);
        String className = Wire.stripJSynPackage(this.sound.getClass().getName());
        switch (phase) {
            case 0: {
                writer.println(String.valueOf(className) + " " + this.getName() + ";");
                break;
            }
            case 1: {
                this.generateSourceInstantiation(writer, className);
            }
        }
    }

    void generateSourceInstantiation(IndentingWriter writer, String className) {
        writer.println("add( " + this.getName() + " = new " + className + "(synthContext) );");
    }

    public SynthSound getSound() {
        return this.sound;
    }

    @Override
    String getTagName() {
        return "unit";
    }
}

