/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.util.IndentingWriter;
import com.softsynth.wire.Wire;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

class SaveAsStream
extends IndentingWriter {
    File targetFile = null;

    public SaveAsStream(OutputStream stream) {
        super(stream);
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(File file) {
        this.targetFile = file;
    }

    void writeAttribute(String name, String value) {
        this.print(" " + name + "=\"" + value + "\"");
    }

    void writeAttribute(String name, int value) {
        this.writeAttribute(name, Integer.toString(value));
    }

    void writeAttribute(String name, double value) {
        this.writeAttribute(name, Double.toString(value));
    }

    void writeRectangle(Rectangle rect) throws IOException {
        if (rect != null) {
            this.writeAttribute("xpos", rect.x);
            this.writeAttribute("ypos", rect.y);
            this.writeAttribute("width", rect.width);
            this.writeAttribute("height", rect.height);
        }
    }

    void writePoint(Point point) throws IOException {
        if (point != null) {
            this.writeAttribute("xpos", point.x);
            this.writeAttribute("ypos", point.y);
        }
    }

    void begin() throws IOException {
        this.println("<?xml version=\"1.0\"?>");
        this.println("<wiredoc version=\"1.3\">");
        this.println("<!-- Saved document from Wire, JSyn's graphical patch editor.");
        this.println("     JSyn is available from: http://www.softsynth.com/jsyn/ -->");
    }

    void end() throws IOException {
        this.println("</wiredoc>");
    }

    void startGroup(Rectangle rect) throws IOException {
        this.print("<group ");
        this.writeRectangle(rect);
        this.println(" >");
    }

    void endGroup() throws IOException {
        this.println("</group>");
    }

    void startPatch(Point point) throws IOException {
        this.print("<patch ");
        this.writePoint(point);
        this.println(" >");
    }

    void endPatch() throws IOException {
        this.println("</patch>");
    }

    void startTag(String name) throws IOException {
        this.print("    <" + name + " ");
    }

    void endTag() throws IOException {
        this.println("/>");
    }

    void writeSampleFormat(int numFrames, int numChannels) throws IOException {
        this.startTag("format");
        this.writeAttribute("frames", numFrames);
        this.writeAttribute("channels", numChannels);
        this.endTag();
    }

    void writeFrequency(double frequency) throws IOException {
        this.startTag("frequency");
        this.writeAttribute("value", frequency);
        this.endTag();
    }

    void writeEnvelopeFrame(double duration, double value) throws IOException {
        this.startTag("frame");
        this.writeAttribute("dur", duration);
        this.writeAttribute("value", value);
        this.endTag();
    }

    void writeEnvelopeLoop(String loopname, int begin, int end) throws IOException {
        this.startTag(loopname);
        this.writeAttribute("begin", begin);
        this.writeAttribute("end", end);
        this.endTag();
    }

    void writePortValue(String tag, String name, double value) throws IOException {
        this.startTag(tag);
        this.writeAttribute("port", name);
        this.writeAttribute("value", Double.toString(value));
        this.endTag();
    }

    void writeNameTag(String tag, String name) throws IOException {
        this.startTag(tag);
        this.writeAttribute(" name", name);
        this.endTag();
    }

    void writeEditor(Rectangle rect) throws IOException {
        this.startTag("editor ");
        this.writeRectangle(rect);
        this.endTag();
    }

    void writeComment(String text) throws IOException {
        this.print("<comment>");
        this.print(text);
        this.println("</comment>");
    }

    void writeFileLink(String fileName) throws IOException {
        this.startTag("link");
        this.writeAttribute("xml:link", "simple");
        String path = Wire.makePathRelative(fileName, this.targetFile);
        this.writeAttribute("href", path);
        this.println(" />");
    }

    void writeFileName(String fileName) throws IOException {
        this.startTag("file");
        String path = Wire.makePathPortable(fileName);
        this.writeAttribute("name", path);
        this.println(" />");
    }

    void writeConnection(String srcName, String srcPortName, int srcPart, String destName, String destPortName, int destPart) throws IOException {
        this.println("<connection>");
        this.print("   <source ");
        this.writeAttribute("name", srcName);
        this.writeAttribute("port", srcPortName);
        this.writeAttribute("part", Integer.toString(srcPart));
        this.println(" />");
        this.print("   <target ");
        this.writeAttribute("name", destName);
        this.writeAttribute("port", destPortName);
        this.writeAttribute("part", Integer.toString(destPart));
        this.println(" />");
        this.println("</connection>");
    }

    public void beginModule(String tagName, String name, String type, Point point) throws IOException {
        this.print("<" + tagName + " ");
        this.writeAttribute("name", name);
        this.writeAttribute("type", type);
        this.writePoint(point);
    }

    public void endModule(String tagName) throws IOException {
        this.println("</" + tagName + ">");
    }
}

