/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.wire.DraggableCanvas;
import com.softsynth.wire.LabelledCanvas;
import com.softsynth.wire.Module;
import com.softsynth.wire.OutputSetJack;
import com.softsynth.wire.Wire;
import com.softsynth.wire.WireJack;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

class NumericRootModule
extends Module {
    OutputSetJack outPort;

    NumericRootModule() {
    }

    public void setupConnectorPort() {
        LabelledCanvas connector = new LabelledCanvas("*");
        this.outPort = new OutputSetJack((Module)this, connector, "output");
        this.addJack(this.outPort);
        connector.setWireJack(this.outPort);
        connector.setPreferredSize(new Dimension(25, 18));
        connector.addMouseListener(this.patch.getPatchPanel());
        connector.addMouseMotionListener(this.patch.getPatchPanel());
        this.arrangeComponents(this.dragger, connector);
    }

    @Override
    void addDragger() {
        this.panel.setLayout(new BorderLayout());
        this.calculateSize();
        this.dragger = new DraggableCanvas("Set");
        this.dragger.setPreferredSize(new Dimension(25, 18));
        this.dragger.setWireJack(new WireJack(this, this.dragger, this.getName()));
        this.dragger.getWireJack().setDragged(this);
        this.dragger.addMouseListener(this.patch.getPatchPanel());
        this.dragger.addMouseMotionListener(this.patch.getPatchPanel());
    }

    void arrangeComponents(Component dragger, Component connector) {
        this.panel.add(dragger, "West");
        this.panel.add(connector, "East");
    }

    @Override
    public void calculateSize() {
        this.panel.setSize(110, 18);
    }

    void setOutPort(double value) {
        this.outPort.sendMessage(Wire.clock.now(), value);
    }

    @Override
    String getTagName() {
        return "misc";
    }
}

