/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.util.TextOutput;
import java.awt.Label;
import javax.swing.JPanel;
import javax.swing.JTextField;

class LabelledTextField
extends JPanel {
    private static final long serialVersionUID = 1L;
    Label nameLabel;
    public JTextField textField;

    public LabelledTextField(String name, String defaultText, int numColumns) {
        this.nameLabel = new Label(name, 2);
        this.add(this.nameLabel);
        this.textField = new JTextField(defaultText, numColumns);
        this.add(this.textField);
        this.validate();
    }

    public String getText() {
        return this.textField.getText();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.nameLabel.setEnabled(enabled);
        this.textField.setEnabled(enabled);
    }

    public double getDouble() throws NumberFormatException {
        double dbl;
        try {
            dbl = Double.valueOf(this.textField.getText());
        }
        catch (NumberFormatException e) {
            TextOutput.println(e.toString());
            TextOutput.println("Bad text = " + this.textField.getText());
            this.textField.setText("Error!");
            this.textField.selectAll();
            throw e;
        }
        return dbl;
    }

    public int getInteger() throws NumberFormatException {
        int val;
        try {
            val = Integer.valueOf(this.textField.getText());
        }
        catch (NumberFormatException e) {
            TextOutput.println(e.toString());
            TextOutput.println("Bad text = " + this.textField.getText());
            this.textField.setText("Error!");
            this.textField.selectAll();
            throw e;
        }
        return val;
    }
}

