/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.EnvelopePoints;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.view11x.EditListener;
import com.softsynth.util.IndentingWriter;
import com.softsynth.wire.EnvelopeDialog;
import com.softsynth.wire.QueuedDataModule;
import com.softsynth.wire.SaveAsStream;
import com.softsynth.wire.Wire;
import java.awt.Rectangle;
import java.io.IOException;

class EnvelopeModule
extends QueuedDataModule
implements EditListener {
    EnvelopeDialog envDialog;
    EnvelopePoints points;
    SynthEnvelope envelope;
    static final int MAX_FRAMES = 128;

    public EnvelopeModule() {
        this(new EnvelopePoints());
        this.points.add(0.1, 1.0);
        this.points.add(0.5, 0.2);
        this.points.add(0.5, 0.0);
    }

    public EnvelopeModule(EnvelopePoints points) {
        this.points = points;
        this.envelope = new SynthEnvelope(128);
        this.channelData = this.envelope;
    }

    @Override
    public Rectangle getEditorBounds() {
        return this.envDialog.getBounds();
    }

    @Override
    public void setEditorBounds(Rectangle rect) {
        this.envDialog.setBounds(rect);
    }

    public void updateEnvelope() {
        int numFrames = this.points.size();
        int i = 0;
        while (i < numFrames) {
            this.envelope.write(i, this.points.getPoint(i), 0, 1);
            ++i;
        }
        this.envelope.setNumFrames(numFrames);
        this.envelope.setSustainLoop(this.points.getSustainBegin(), this.points.getSustainEnd());
        this.envelope.setReleaseLoop(this.points.getReleaseBegin(), this.points.getReleaseEnd());
        this.getPatch().setModified(true);
    }

    @Override
    public void objectEdited(Object editor, Object objPoints) {
        this.updateEnvelope();
    }

    @Override
    public void setupJacks() {
        super.setupJacks();
        this.outJack.getComponent().setBackground(Wire.ENVQUEUE_PORT_COLOR);
        this.outJack.setSupportMask(this.outJack.getSupportMask() | 4);
        this.envDialog = new EnvelopeDialog(this.patch.getPatchPanel().getFrame(), this, this.points);
        this.envDialog.editor.addEditListener(this);
        this.updateEnvelope();
    }

    @Override
    boolean edit() {
        this.envDialog.show();
        return true;
    }

    @Override
    public void generateSource(IndentingWriter writer, int phase) throws IOException {
        super.generateSource(writer, phase);
        switch (phase) {
            case 0: {
                writer.println("SynthEnvelope " + this.getName() + ";");
                break;
            }
            case 1: {
                String dataName = String.valueOf(this.getName()) + "Data";
                writer.println("double[] " + dataName + " = {");
                writer.indent();
                int i = 0;
                while (i < this.points.size()) {
                    double[] dar = this.points.getPoint(i);
                    writer.println(String.valueOf(dar[0]) + ", " + dar[1] + ", ");
                    ++i;
                }
                writer.undent();
                writer.println("};");
                writer.println(String.valueOf(this.getName()) + " = new SynthEnvelope( synthContext, " + dataName + " );");
                writer.println(String.valueOf(dataName) + " = null;");
                writer.println(String.valueOf(this.getName()) + ".setSustainLoop( " + this.points.getSustainBegin() + ", " + this.points.getSustainEnd() + " );");
                writer.println(String.valueOf(this.getName()) + ".setReleaseLoop( " + this.points.getReleaseBegin() + ", " + this.points.getReleaseEnd() + " );");
            }
        }
    }

    @Override
    void saveContentToStream(SaveAsStream stream) throws IOException {
        super.saveContentToStream(stream);
        int i = 0;
        while (i < this.points.size()) {
            double[] dar = this.points.getPoint(i);
            stream.writeEnvelopeFrame(dar[0], dar[1]);
            ++i;
        }
        stream.writeEnvelopeLoop("sustain", this.points.getSustainBegin(), this.points.getSustainEnd());
        stream.writeEnvelopeLoop("release", this.points.getReleaseBegin(), this.points.getReleaseEnd());
        stream.writeEditor(this.getEditorBounds());
    }

    @Override
    public String getTagName() {
        return "envelope";
    }
}

