/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.util.TextOutput;
import com.softsynth.wire.LoaderContext;
import com.softsynth.wire.Module;
import com.softsynth.wire.Patch;
import com.softsynth.wire.PortDescriptor;
import com.softsynth.wire.RecursiveLoader;
import com.softsynth.wire.WireJack;
import com.softsynth.wire.WirePortNotFoundException;
import java.util.Hashtable;

class ConnectionLoader
extends RecursiveLoader {
    Patch patch;
    LoaderContext ldcon;
    PortDescriptor source;
    PortDescriptor target;

    public ConnectionLoader(String tag, LoaderContext ldcon) {
        super(tag);
        this.patch = ldcon.patch;
        this.ldcon = ldcon;
    }

    PortDescriptor handlePortDescriptor(Hashtable attributes) {
        PortDescriptor pd = new PortDescriptor();
        pd.moduleName = (String)attributes.get("name");
        String newName = (String)this.ldcon.nameRemapper.get(pd.moduleName);
        if (newName != null) {
            pd.moduleName = newName;
        }
        pd.portName = (String)attributes.get("port");
        if (pd.portName.equals("port")) {
            pd.portName = pd.moduleName;
            TextOutput.println("FIXME - Converting port to " + pd.portName);
        }
        pd.part = this.getAttribute(attributes, "part", 0);
        return pd;
    }

    @Override
    public void handleBeginElement(String tag, Hashtable attributes) {
        if (tag.equals("source")) {
            this.source = this.handlePortDescriptor(attributes);
        } else if (tag.equals("target")) {
            this.target = this.handlePortDescriptor(attributes);
        } else {
            super.handleBeginElement(tag, attributes);
        }
    }

    @Override
    public void handleEndElement() {
        try {
            Module sourceModule = this.patch.findModule(this.source.moduleName);
            if (sourceModule == null) {
                throw new WirePortNotFoundException("Can't find source module ." + this.source.moduleName);
            }
            WireJack sourcePort = sourceModule.getJack(this.source.portName, this.source.part);
            Module targetModule = this.patch.findModule(this.target.moduleName);
            if (targetModule == null) {
                throw new WirePortNotFoundException("Can't find target module " + this.target.moduleName);
            }
            WireJack targetPort = targetModule.getJack(this.target.portName, this.target.part);
            sourcePort.connect(targetPort);
        }
        catch (WirePortNotFoundException e) {
            TextOutput.println("Cannot connect to missing port " + e);
        }
        super.handleEndElement();
    }
}

