/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.tools.view;

import com.softsynth.tools.view.RotaryKnob;
import com.softsynth.tools.view.TextFieldDouble;
import com.softsynth.view.ValueController;
import com.softsynth.view.ValueEvent;
import com.softsynth.view.ValueListener;
import java.awt.BorderLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class EditableRotaryKnob
extends Panel
implements ValueListener,
ActionListener,
ValueController {
    RotaryKnob knob;
    TextFieldDouble field;
    Label label;

    public EditableRotaryKnob(String text, double val, double min, double max, int numCharacters) {
        this.setLayout(new BorderLayout());
        if (text != null) {
            this.setText(text);
        }
        this.knob = new RotaryKnob(val, min, max);
        this.add("Center", this.knob);
        Panel fieldPanel = new Panel();
        this.knob.addValueListener(this);
        if (numCharacters > 0) {
            this.add("South", fieldPanel);
            this.field = new TextFieldDouble(val, numCharacters);
            fieldPanel.add(this.field);
            this.field.addActionListener(this);
        }
    }

    public EditableRotaryKnob(double val, double min, double max) {
        this(null, val, min, max, 8);
    }

    public RotaryKnob getKnob() {
        return this.knob;
    }

    public TextField getTextField() {
        return this.field;
    }

    public void setText(String text) {
        if (this.label == null) {
            this.label = new Label(text, 1);
            this.add("North", this.label);
        } else {
            this.label.setText(text);
        }
    }

    public String getText() {
        return this.label.getText();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.field != null) {
            try {
                double val = this.field.getValue();
                this.knob.setValue(val);
            }
            catch (NumberFormatException exp) {
                this.field.setText("ERROR");
                this.field.selectAll();
            }
        }
    }

    @Override
    public void valueChanged(ValueEvent e) {
        this.setValueText(e.getValue());
    }

    public void setValueText(double value) {
        if (this.field != null) {
            this.field.setValue(value);
        }
    }

    @Override
    public void setValue(double value) {
        this.knob.setValue(value);
    }

    public double getValue() {
        return this.knob.getValue();
    }

    @Override
    public double getDoubleValue() {
        return this.knob.getDoubleValue();
    }

    @Override
    public void setMaximum(double maximum) {
        this.knob.setMaximum(maximum);
    }

    @Override
    public double getMaximum() {
        return this.knob.getMaximum();
    }

    @Override
    public void setMinimum(double minimum) {
        this.knob.setMinimum(minimum);
    }

    @Override
    public double getMinimum() {
        return this.knob.getMinimum();
    }

    @Override
    public void addValueListener(ValueListener listener) {
        this.knob.addValueListener(listener);
    }

    @Override
    public void removeValueListener(ValueListener listener) {
        this.knob.removeValueListener(listener);
    }
}

