/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.support;

import com.softsynth.support.TextAreaOutputStream;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;

public class JavaSniffer
extends Applet {
    TextArea textArea;
    TextAreaOutputStream textOut;
    PrintStream out;
    Button installButton;
    String pluginID = null;

    public static void main(String[] args) {
        JavaSniffer applet = new JavaSniffer();
        Frame f = new Frame("Sniff JVM");
        f.add("Center", applet);
        f.setSize(600, 350);
        applet.init();
        f.show();
        applet.start();
    }

    @Override
    public void start() {
        String buttonText = "Install JSyn Plugin";
        this.textArea = new TextArea();
        this.textOut = new TextAreaOutputStream(this.textArea);
        this.out = new PrintStream(this.textOut);
        this.setLayout(new BorderLayout());
        this.add("Center", this.textArea);
        this.pluginID = this.getID();
        if (this.pluginID == null) {
            this.out.println("Sorry - JSyn not supported for this platform.");
            buttonText = "Help";
        } else {
            this.out.println("Use plugin: " + this.pluginID);
        }
        Panel buttonPanel = new Panel();
        this.installButton = new Button(buttonText);
        buttonPanel.add(this.installButton);
        this.add("North", buttonPanel);
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaSniffer.this.jumpToInstall();
            }
        });
        this.validate();
    }

    @Override
    public void stop() {
        this.removeAll();
    }

    void jumpToInstall() {
        String pageID = this.pluginID == null ? "none" : this.pluginID;
        String pageName = "http://www.softsynth.com/jsyn/plugins/install_" + pageID + ".html";
        try {
            URL installerPage = new URL(pageName);
            this.getAppletContext().showDocument(installerPage);
        }
        catch (MalformedURLException exc) {
            this.out.println("Caught " + exc);
        }
    }

    private double getJavaVersion() {
        double javaVersion = 0.0;
        String versionString = System.getProperty("java.version");
        this.out.println("java.version = " + versionString);
        try {
            int secondPeriod;
            String goodVersionString = versionString;
            int firstPeriod = versionString.indexOf(46);
            if (firstPeriod > 0 && (secondPeriod = versionString.indexOf(46, firstPeriod + 1)) > 0) {
                goodVersionString = versionString.substring(0, secondPeriod);
            }
            javaVersion = Double.valueOf(goodVersionString);
        }
        catch (NumberFormatException enf) {
            System.err.println(enf);
        }
        return javaVersion;
    }

    String getID() {
        this.out.println("Now selecting the best plugin for your browser:");
        String id = null;
        double javaVersion = this.getJavaVersion();
        String userAgent = null;
        try {
            userAgent = this.getParameter("userAgent");
            if (userAgent != null) {
                this.out.println("userAgent = " + userAgent);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String javaVendor = System.getProperty("java.vendor");
        this.out.println("os.name = " + osName);
        this.out.println("os.arch = " + osArch);
        this.out.println("java.vendor = " + javaVendor);
        if (osName != null) {
            if (osName.startsWith("Windows")) {
                if (javaVersion <= 1.1) {
                    if (javaVendor.indexOf("Netscape") >= 0) {
                        id = "win_ns";
                    } else if (javaVendor.indexOf("Microsoft") >= 0) {
                        id = "win_ie";
                    }
                } else if (javaVendor.indexOf("Sun") >= 0) {
                    id = "win_sun";
                }
            } else if (osName.startsWith("Linux")) {
                id = "linux_sun";
            } else if (osName.startsWith("Mac")) {
                if (javaVersion <= 1.1 && osArch.equals("PowerPC")) {
                    if (javaVendor.indexOf("Netscape") >= 0) {
                        id = "mac_ns";
                    } else if (javaVendor.indexOf("Apple") >= 0) {
                        id = "mac_mrj";
                    }
                } else if (javaVendor.indexOf("Apple") >= 0) {
                    id = "mac_osx";
                }
            }
        }
        if (javaVersion < 1.1) {
            this.out.println("You are using a very old version of Java!");
            this.out.println("We recommend upgrading to a newer browser.");
        }
        return id;
    }
}

