/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view102;

import com.softsynth.jsyn.view102.CustomFaderListener;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Vector;

public class InternalCustomFader
extends Canvas {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    Vector listeners = new Vector();
    boolean isHorizontal;
    int minVal;
    int maxVal;
    int value;
    int lineIncrement = 1;
    int blockIncrement = 10;
    int visibleAmount;
    int imageSizeX = -1;
    int imageSizeY = -1;
    protected static boolean isShiftDown;
    protected static boolean isMouseDown;
    final int ARROW_SIZE_Z = 20;
    int thumbSize;
    int scrollerLowZ;
    int scrollerMidZ;
    int scrollerHighZ;
    int sizeW;
    int sizeZ;
    int lowZ;
    int highZ;
    static boolean currentlyDragging;
    static InternalCustomFader dragSourceFader;
    static InternalCustomFader dragTargetFader;
    static int dragOffsetX;
    static int dragOffsetY;
    Image offscreenImage;

    static {
        currentlyDragging = false;
    }

    public InternalCustomFader(int orientation, int val, int visible, int min, int max) {
        this.isHorizontal = orientation == 0;
        this.value = val;
        this.minVal = min;
        this.maxVal = max;
        this.setVisibleAmount(visible);
        this.setBackground(Color.lightGray);
    }

    public void addCustomFaderListener(CustomFaderListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeCustomFaderListener(CustomFaderListener listener) {
        this.listeners.removeElement(listener);
    }

    public void setValues(int val, int min, int max) {
        this.value = val;
        this.minVal = min;
        this.maxVal = max;
    }

    public int getValue() {
        return this.value;
    }

    public void setBlockIncrement(int v) {
        this.blockIncrement = v;
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public void setUnitIncrement(int v) {
        this.lineIncrement = v;
    }

    public int getLineIncrement() {
        return this.lineIncrement;
    }

    public int getVisibleAmount(int amount) {
        return this.visibleAmount;
    }

    public void setVisibleAmount(int amount) {
        if (amount < 1) {
            amount = 1;
        }
        this.visibleAmount = amount;
        this.setBlockIncrement(amount);
        this.updateThumbSize();
    }

    private void setInternalSize(int width, int height) {
        if (this.imageSizeX == width && this.imageSizeY == height) {
            return;
        }
        this.imageSizeX = width;
        this.imageSizeY = height;
        if (this.isHorizontal) {
            this.sizeZ = width;
            this.sizeW = height;
        } else {
            this.sizeZ = height;
            this.sizeW = width;
        }
        if (this.sizeZ < 50) {
            this.sizeZ = 50;
        }
        this.updateThumbSize();
        this.buildOffscreenImage();
    }

    private void updateThumbSize() {
        int spanZ = this.sizeZ - 40;
        this.thumbSize = spanZ * this.visibleAmount / (this.maxVal - this.minVal + this.visibleAmount);
        if (this.thumbSize < 10) {
            this.thumbSize = 10;
        }
        this.lowZ = 20 + this.thumbSize / 2;
        this.highZ = this.sizeZ - this.lowZ;
    }

    private boolean inLowArrow(int z) {
        return z <= 20 && z >= 0;
    }

    private boolean inHighArrow(int z) {
        return z >= this.sizeZ - 20 && z <= this.sizeZ;
    }

    private void tellListeners() {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            CustomFaderListener listener = (CustomFaderListener)e.nextElement();
            listener.customFaderValueChanged(this, this.value);
        }
    }

    private int lowOfScroller(int z) {
        return this.scaleClipDeltaZ(this.scrollerMidZ - z);
    }

    private int highOfScroller(int z) {
        return this.scaleClipDeltaZ(z - this.scrollerMidZ);
    }

    private int scaleClipDeltaZ(int dz) {
        int dv;
        if (isShiftDown) {
            dv = this.deltaZToDeltaValue(dz);
        } else {
            if (dz < this.thumbSize / 2) {
                return 0;
            }
            dv = this.blockIncrement;
        }
        return dv;
    }

    private void addToValue(int dz) {
        this.value += dz;
        if (this.value > this.maxVal) {
            this.value = this.maxVal;
        } else if (this.value < this.minVal) {
            this.value = this.minVal;
        }
        this.tellListeners();
        this.repaint();
    }

    private void isOnScroller(int z) {
        currentlyDragging |= z >= this.scrollerLowZ && z <= this.scrollerHighZ;
    }

    protected void handleMousePressed(boolean isShiftDown, int x, int y) {
        InternalCustomFader.isShiftDown = isShiftDown;
        isMouseDown = true;
        dragSourceFader = this;
        dragTargetFader = this;
        currentlyDragging = isShiftDown;
        this.setFaderByXY(x, y);
    }

    void setFaderByXY(int x, int y) {
        int z;
        if (this.isHorizontal) {
            z = x;
            int w = y;
        } else {
            z = y;
            int w = x;
        }
        if (this.inLowArrow(z)) {
            this.addToValue(-this.lineIncrement);
        } else if (this.inHighArrow(z)) {
            this.addToValue(this.lineIncrement);
        } else {
            int dz = this.lowOfScroller(z);
            if (dz > 0) {
                this.addToValue(-dz);
            } else {
                dz = this.highOfScroller(z);
                if (dz > 0) {
                    this.addToValue(dz);
                } else {
                    this.isOnScroller(z);
                }
            }
        }
    }

    protected void handleMouseDragged(int x, int y) {
        if (currentlyDragging) {
            if (dragTargetFader != null && dragTargetFader != dragSourceFader) {
                dragTargetFader.dragFaderByXY(x += dragOffsetX, y += dragOffsetY);
            } else {
                this.dragFaderByXY(x, y);
            }
        }
    }

    void dragFaderByXY(int x, int y) {
        int z;
        if (this.isHorizontal) {
            z = x;
            int w = y;
        } else {
            z = y;
            int w = x;
        }
        this.value = this.zToValue(z);
        if (this.value > this.maxVal) {
            this.value = this.maxVal;
        } else if (this.value < this.minVal) {
            this.value = this.minVal;
        }
        this.tellListeners();
        this.repaint();
    }

    protected void handleMouseEntered(int x, int y) {
        if (isMouseDown && isShiftDown) {
            dragTargetFader = this;
            dragOffsetX = InternalCustomFader.dragSourceFader.bounds().x - this.bounds().x;
            dragOffsetY = InternalCustomFader.dragSourceFader.bounds().y - this.bounds().y;
            this.handleMouseDragged(x, y);
        }
    }

    protected void handleMouseExited(int x, int y) {
        if (isMouseDown && isShiftDown) {
            dragTargetFader = null;
        }
    }

    protected void handleMouseReleased(int x, int y) {
        isMouseDown = false;
        currentlyDragging = false;
        dragSourceFader = null;
    }

    private int deltaZToDeltaValue(int dz) {
        return dz * (this.maxVal - this.minVal) / (this.highZ - this.lowZ);
    }

    private int zToValue(int z) {
        if (z < this.lowZ) {
            return this.minVal;
        }
        if (z > this.highZ) {
            return this.maxVal;
        }
        return this.deltaZToDeltaValue(z - this.lowZ) + this.minVal;
    }

    private int deltaValueToDeltaZ(int dv) {
        return dv * (this.highZ - this.lowZ) / (this.maxVal - this.minVal);
    }

    private int valueToZ(int val) {
        if (val < this.minVal) {
            return this.lowZ;
        }
        if (val > this.maxVal) {
            return this.highZ;
        }
        return this.deltaValueToDeltaZ(this.value - this.minVal) + this.lowZ;
    }

    public void setValue(int v) {
        if (v < this.minVal || v > this.maxVal) {
            throw new IllegalArgumentException("illegal CustomFader value: " + v);
        }
        this.value = v;
        this.tellListeners();
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    private void buildOffscreenImage() {
        this.offscreenImage = this.createImage(this.imageSizeX, this.imageSizeY);
    }

    private void zwFillPolygon(Graphics gg, int[] zvals, int[] wvals, int numPoints) {
        if (this.isHorizontal) {
            gg.fillPolygon(zvals, wvals, zvals.length);
        } else {
            gg.fillPolygon(wvals, zvals, zvals.length);
        }
    }

    private void drawLowArrow(Graphics bg) {
        this.zwDrawBevels(bg, 1, 1, 20, this.sizeW - 2);
        int inset = 6;
        int zOneThird = 6;
        int zTwoThirds = 12;
        int[] zvals = new int[]{zOneThird, zTwoThirds, zTwoThirds};
        int[] wvals = new int[]{this.sizeW / 2, inset, this.sizeW - inset};
        bg.setColor(Color.black);
        this.zwFillPolygon(bg, zvals, wvals, zvals.length);
    }

    private void drawHighArrow(Graphics bg) {
        int leftMargin = this.sizeZ - 1 - 20;
        this.zwDrawBevels(bg, leftMargin, 1, this.sizeZ - 1, this.sizeW - 2);
        int inset = 6;
        int zOneThird = 6 + leftMargin;
        int zTwoThirds = 12 + leftMargin;
        int[] zvals = new int[]{zOneThird, zOneThird, zTwoThirds};
        int[] wvals = new int[]{inset, this.sizeW - inset, this.sizeW / 2};
        bg.setColor(Color.black);
        this.zwFillPolygon(bg, zvals, wvals, zvals.length);
    }

    private void drawScrollRect(Graphics bg) {
        this.scrollerMidZ = this.valueToZ(this.value);
        this.scrollerLowZ = this.scrollerMidZ - this.thumbSize / 2;
        this.scrollerHighZ = this.scrollerMidZ + this.thumbSize / 2;
        this.zwDrawBevels(bg, this.scrollerLowZ, 1, this.scrollerHighZ, this.sizeW - 2);
    }

    private void zwDrawBevels(Graphics bg, int z1, int w1, int z2, int w2) {
        int delta = 2;
        int[] zvals = new int[]{z1, z2, z2 - delta, z1 + delta};
        int[] wvals = new int[]{w1, w1, w1 + delta, w1 + delta};
        bg.setColor(Color.white);
        this.zwFillPolygon(bg, zvals, wvals, zvals.length);
        int[] zvals2 = new int[]{z1, z1, z1 + delta, z1 + delta};
        int[] wvals2 = new int[]{w1, w2, w2 - delta, w1 + delta};
        bg.setColor(Color.white);
        this.zwFillPolygon(bg, zvals2, wvals2, zvals2.length);
        int[] zvals3 = new int[]{z2, z2, z2 - delta, z2 - delta};
        int[] wvals3 = new int[]{w1, w2, w2 - delta, w1 + delta};
        bg.setColor(Color.black);
        this.zwFillPolygon(bg, zvals3, wvals3, zvals3.length);
        int[] zvals4 = new int[]{z2, z2 - delta, z1 + delta, z1};
        int[] wvals4 = new int[]{w2, w2 - delta, w2 - delta, w2};
        bg.setColor(Color.black);
        this.zwFillPolygon(bg, zvals4, wvals4, zvals4.length);
    }

    @Override
    public void paint(Graphics g) {
        this.setInternalSize(this.bounds().width, this.bounds().height);
        if (this.offscreenImage == null) {
            this.buildOffscreenImage();
        }
        if (this.offscreenImage != null) {
            Graphics bg = this.offscreenImage.getGraphics();
            bg.setColor(this.getBackground());
            bg.fillRect(0, 0, this.imageSizeX, this.imageSizeY);
            bg.setColor(Color.black);
            bg.drawLine(0, 0, this.imageSizeX - 1, 0);
            bg.drawLine(this.imageSizeX - 1, 0, this.imageSizeX - 1, this.imageSizeY - 1);
            bg.drawLine(this.imageSizeX - 1, this.imageSizeY - 1, 0, this.imageSizeY - 1);
            bg.drawLine(0, 0, 0, this.imageSizeY - 1);
            this.drawLowArrow(bg);
            this.drawHighArrow(bg);
            this.drawScrollRect(bg);
            g.drawImage(this.offscreenImage, 0, 0, this);
            bg.dispose();
        } else {
            System.out.println("Not ready to draw offscreenImage");
        }
    }
}

