/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.qa;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.qa.QA_Tools;
import com.softsynth.jsyn.qa.QuadruplerCircuit;
import java.applet.Applet;
import java.awt.Component;
import java.awt.TextArea;

public class QA_Nested1
extends Applet {
    QA_Tools tools;
    AddUnit adder;
    QuadruplerCircuit quad;

    public static void main(String[] args) {
        QA_Nested1 applet = new QA_Nested1();
        AppletFrame frame = new AppletFrame("Load All Units", applet);
        frame.resize(600, 450);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        TextArea report = new TextArea(25, 70);
        this.add(report);
        this.tools = new QA_Tools(report);
        this.getParent().validate();
        this.getToolkit().sync();
        try {
            Synth.startEngine(0);
            this.adder = new AddUnit();
            this.quad = new QuadruplerCircuit();
            this.tools.println("quad.input has " + this.quad.input.getNumParts() + " parts.");
            this.adder.start();
            this.quad.start();
            this.checkQuad(0.1, this.quad.input);
            this.checkQuad(-0.2, this.quad.input);
            this.adder.output.connect(this.quad.input);
            this.checkQuad(0.2, this.adder.inputA);
            this.checkQuad(-0.1, this.adder.inputA);
            this.tools.printSummary();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    void checkQuad(double a, SynthInput port) throws SynthException {
        double c = a * 4.0;
        port.set(a);
        Synth.sleepForTicks(20);
        double answer = this.quad.output.get();
        if (this.tools.matchDoubles(answer, c, 1.0E-5)) {
            this.tools.printSuccess("set, " + a + " * 4 = " + answer);
        } else {
            this.tools.printError("set, " + a + " * 4  => " + answer);
        }
    }

    @Override
    public void stop() {
        try {
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

