/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.tuna;

import com.softsynth.jsyn.SynthBusInput;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.circuits.RingModBell;
import com.softsynth.jsyn.examples.tuna.MelodicSequence;
import com.softsynth.jsyn.examples.tuna.TunaRiff;
import java.awt.Panel;

class TunaBell
extends TunaRiff {
    RingModBell unitBell;

    public TunaBell(Panel panel, SynthBusInput bus, double ampl) throws SynthException {
        super(panel, "Fast Bell", bus, new RingModBell(), ampl);
        this.unitBell = (RingModBell)this.unitNote;
        this.unitBell.halfLife.set(0.1);
    }

    @Override
    public boolean play(int time, MelodicSequence melody) throws SynthException {
        boolean ifChange = super.play(time, melody);
        if (this.playBox.getState()) {
            double pitch = melody.pitchAt(0);
            int i = 0;
            while (i < melody.size()) {
                int dur = melody.getTicksPerBeat() / 2;
                int numNotes = melody.durationAt(i) / dur;
                if ((i & 3) == 0) {
                    pitch = melody.pitchAt(i) * 1.5;
                    while (pitch < 1200.0) {
                        pitch *= 2.0;
                    }
                }
                int j = 0;
                while (j < numNotes) {
                    int now = time + dur * j;
                    if (j == 0 || (this.rand.nextInt() & 3) != 0) {
                        this.unitNote.note(now, dur / 2, pitch, this.ampl);
                    }
                    ++j;
                }
                time += melody.durationAt(i);
                ++i;
            }
        }
        return ifChange;
    }
}

