/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.tuna;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.circuits.Reverb1;
import com.softsynth.jsyn.examples.tuna.MelodicSequence;
import com.softsynth.jsyn.examples.tuna.TunaBell;
import com.softsynth.jsyn.examples.tuna.TunaGrains;
import com.softsynth.jsyn.examples.tuna.TunaLead;
import com.softsynth.jsyn.examples.tuna.TunaRiff;
import com.softsynth.jsyn.examples.tuna.TunaSwarm;
import com.softsynth.jsyn.examples.tuna.TunaSwoop;
import com.softsynth.jsyn.view102.UsageDisplay;
import java.applet.Applet;
import java.awt.GridLayout;
import java.util.Vector;

public class Tuna
extends Applet
implements Runnable {
    Vector riffs;
    MelodicSequence melody;
    LineOut unitOut;
    Reverb1 unitReverb;
    boolean keepPlaying;
    Thread mainThread = null;

    public static void main(String[] args) {
        Tuna applet = new Tuna();
        AppletFrame frame = new AppletFrame("Tuna", applet);
        frame.resize(550, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        this.startSynth();
        this.keepPlaying = true;
        this.mainThread = new Thread(this);
        this.mainThread.start();
    }

    @Override
    public void stop() {
        this.keepPlaying = false;
        this.stopSynth();
    }

    public void startSynth() throws SynthException {
        Synth.startEngine(0);
        this.melody = new MelodicSequence(64);
        Synth.verbosity = 0;
        this.unitReverb = new Reverb1();
        this.unitOut = new LineOut();
        this.unitReverb.setPriority(0);
        this.unitReverb.output.connect(0, this.unitOut.input, 0);
        this.unitReverb.output.connect(0, this.unitOut.input, 1);
        this.add(new UsageDisplay());
        this.riffs = new Vector();
        this.riffs.addElement(new TunaLead(this, this.unitReverb.busInput, 0.2));
        this.riffs.addElement(new TunaBell(this, this.unitReverb.busInput, 0.2));
        this.riffs.addElement(new TunaSwoop(this, this.unitReverb.busInput, 0.3));
        this.riffs.addElement(new TunaGrains(this, this.unitReverb.busInput, 0.5));
        this.riffs.addElement(new TunaSwarm(this, this.unitReverb.busInput, 0.4));
        this.unitReverb.start();
        this.unitOut.start();
        this.getParent().validate();
        this.getToolkit().sync();
    }

    public void stopSynth() throws SynthException {
        this.unitOut.stop();
        this.unitOut.delete();
        this.unitOut = null;
        this.removeAll();
        Synth.verbosity = 0;
        Synth.stopEngine();
    }

    @Override
    public void run() {
        int maxElapsed = -1;
        try {
            int advance = (int)(Synth.getTickRate() * 0.2);
            int now = Synth.getTickCount();
            while (this.keepPlaying) {
                int beginTick = Synth.getTickCount();
                this.play(now + advance);
                int endTick = Synth.getTickCount();
                int elapsed = endTick - beginTick;
                if (elapsed > maxElapsed) {
                    maxElapsed = elapsed;
                }
                Synth.sleepUntilTick(now += this.melody.getTotalDuration());
            }
        }
        catch (SynthException e) {
            System.out.println("Caught " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(int now) throws SynthException {
        MelodicSequence melodicSequence = this.melody;
        synchronized (melodicSequence) {
            int i = 0;
            while (i < this.riffs.size()) {
                TunaRiff riff = (TunaRiff)this.riffs.elementAt(i);
                riff.play(now, this.melody);
                ++i;
            }
        }
    }
}

