/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.tuna;

import com.softsynth.jsyn.Synth;

class MelodicSequence {
    int[] durations;
    double[] pitches;
    double[] amplitudes;
    int ticksPerBeat;
    int numNotes;
    int totalDuration;

    public MelodicSequence(int maxNotes) {
        this.pitches = new double[maxNotes];
        this.amplitudes = new double[maxNotes];
        this.durations = new int[maxNotes];
        this.ticksPerBeat = (int)(Synth.getTickRate() * 0.3);
        this.clear();
    }

    public void add(int duration, double pitch, double amplitude) {
        this.durations[this.numNotes] = duration;
        this.totalDuration += duration;
        this.pitches[this.numNotes] = pitch;
        this.amplitudes[this.numNotes] = amplitude;
        ++this.numNotes;
    }

    public void clear() {
        this.numNotes = 0;
        this.totalDuration = 0;
    }

    public int getTotalDuration() {
        return this.totalDuration;
    }

    public void setTicksPerBeat(int ticks) {
        this.ticksPerBeat = ticks;
    }

    public int getTicksPerBeat() {
        return this.ticksPerBeat;
    }

    public int size() {
        return this.numNotes;
    }

    public double pitchAt(int n) {
        return this.pitches[n];
    }

    public int durationAt(int n) {
        return this.durations[n];
    }

    public double amplitudeAt(int n) {
        return this.amplitudes[n];
    }
}

