/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.pinwheels;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.circuits.FilteredSawtoothBL;
import com.softsynth.jsyn.examples.pinwheels.PitchSpinner;
import com.softsynth.jsyn.util.BussedVoiceAllocator;

class SpinnerThread
extends Thread {
    static final double MAX_DELAY = 0.1;
    static final int MAX_NUM_VOICES = 6;
    PitchSpinner spinner;
    public BussedVoiceAllocator allocator;
    boolean go = true;

    public SpinnerThread(PitchSpinner spinner) throws SynthException {
        this.spinner = spinner;
        this.allocator = new BussedVoiceAllocator(6){

            @Override
            public SynthCircuit makeVoice() throws SynthException {
                FilteredSawtoothBL circ = new FilteredSawtoothBL();
                return this.addVoiceToMix(circ);
            }
        };
    }

    @Override
    public void run() {
        while (this.go) {
            int msec;
            try {
                msec = this.playPitches();
            }
            catch (SynthException e) {
                System.err.println(e);
                return;
            }
            try {
                Thread.sleep(msec);
            }
            catch (InterruptedException e) {
                System.err.println(e);
                return;
            }
        }
    }

    public void kill() {
        this.go = false;
    }

    int playPitches() throws SynthException {
        double x2;
        int delay1 = 0;
        int delay2 = 0;
        int duration = 100;
        double[] dar = this.spinner.getSortedXY();
        double timeScalar = Synth.getTickRate() * 1.0;
        double firstX = x2 = dar[0];
        int now = Synth.getTickCount();
        int i = 0;
        while (i < dar.length / 2) {
            double x1 = x2;
            delay1 = delay2;
            if (i < dar.length / 2 - 1) {
                x2 = dar[(i + 1) * 2];
                delay2 = (int)((x2 - firstX) * timeScalar);
                duration = (delay2 - delay1) / 2;
            }
            double y = dar[i * 2 + 1];
            double freq = this.spinner.yToFrequency(y);
            int nextTime = now + delay1;
            SynthNote voice = (SynthNote)this.allocator.steal(nextTime);
            if (voice == null) {
                System.err.println("Couldn't allocate voice.");
            } else {
                voice.note(nextTime, duration, freq, 0.16666666666666666);
            }
            ++i;
        }
        return (int)(2.0 * (1000.0 * (double)delay2 / Synth.getTickRate()));
    }
}

