/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.perfrack;

import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthMixer;
import com.softsynth.jsyn.view102.CustomFader;
import com.softsynth.jsyn.view102.CustomFaderListener;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

class RackUnitMixControl
extends Panel
implements CustomFaderListener {
    SynthMixer mixer;
    int track;
    CustomFader gainFader;
    CustomFader panFader;
    CustomFader sendFader;
    double gain;
    double pan;
    double send;

    public RackUnitMixControl(String title, SynthMixer mixer, int track) {
        this.mixer = mixer;
        this.track = track;
        this.setLayout(new GridLayout(1, 0));
        this.add(new Label(title, 2));
        this.gainFader = new CustomFader(0, 100, 1, 0, 100);
        this.add(this.gainFader);
        this.gainFader.addCustomFaderListener(this);
        this.panFader = new CustomFader(0, 50, 1, 0, 100);
        this.add(this.panFader);
        this.panFader.addCustomFaderListener(this);
        this.sendFader = new CustomFader(0, 0, 1, 0, 100);
        this.add(this.sendFader);
        this.sendFader.addCustomFaderListener(this);
    }

    void updateGains() {
        try {
            this.mixer.setGain(this.track, 0, this.gain * (1.0 - this.pan));
            this.mixer.setGain(this.track, 1, this.gain * this.pan);
            this.mixer.setGain(this.track, 2, this.gain * this.send);
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
            return;
        }
    }

    public void setGain(double gain) {
        this.gain = gain;
        this.gainFader.setValue((int)(gain * 100.0));
        this.updateGains();
    }

    public double getGain() {
        return this.gain;
    }

    public void setPan(double pan) {
        this.pan = pan;
        this.panFader.setValue((int)(pan * 100.0));
        this.updateGains();
    }

    public double getPan() {
        return this.pan;
    }

    public void setAuxSend(double send) {
        this.send = send;
        this.sendFader.setValue((int)(send * 100.0));
        this.updateGains();
    }

    public double getAuxSend() {
        return this.pan;
    }

    @Override
    public void customFaderValueChanged(Object fdr, int value) {
        CustomFader fader = (CustomFader)fdr;
        if (fader == this.gainFader) {
            this.gain = (double)this.gainFader.getValue() / 100.0;
            this.updateGains();
        } else if (fader == this.panFader) {
            this.pan = (double)this.panFader.getValue() / 100.0;
            this.updateGains();
        } else if (fader == this.sendFader) {
            this.send = (double)this.sendFader.getValue() / 100.0;
            this.updateGains();
        }
    }
}

