/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.RedNoise;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.examples.FilteredSawEnv;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class TJ_PlayKeys2
extends Applet
implements KeyListener {
    RedNoise redNoise;
    FilteredSawEnv fse;
    LineOut lineOut;
    static double freq = 440.0;
    int lastKeyDown = -1;

    public static void main(String[] args) {
        TJ_PlayKeys2 applet = new TJ_PlayKeys2();
        AppletFrame frame = new AppletFrame("Play ASCII keyboard.", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            Synth.verbosity = 0;
            this.fse = new FilteredSawEnv();
            this.redNoise = new RedNoise();
            this.lineOut = new LineOut();
            this.fse.output.connect(0, this.lineOut.input, 0);
            this.redNoise.output.connect(0, this.lineOut.input, 1);
            this.redNoise.amplitude.set(0.0);
            this.fse.start();
            this.redNoise.start();
            this.lineOut.start();
            this.fse.attack();
            this.fse.setStage(Synth.getTickCount(), 0);
            this.addKeyListener(this);
            this.add(new Label("Play the ASCII keyboard. Hit 'A' to start sound."));
            this.add(new Label("Q,W,E = random freq patterns"));
            this.add(new Label("R,T,Y = on,off,loop"));
            this.add(new Label("U,I,O = play noise"));
            this.add(new Label("A,S,D = queue cutoff envelope loops"));
            this.add(new Label("Z,X,C = change envelope rate"));
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        this.lineOut.delete();
        this.lineOut = null;
        this.fse.delete();
        this.fse = null;
        Synth.verbosity = 0;
        Synth.stopEngine();
    }

    void randomFreqPattern(int numNotes, double dur, double span) {
        int time = Synth.getTickCount();
        int durTicks = (int)(dur * Synth.getTickRate());
        int i = 0;
        while (i < numNotes) {
            if ((freq += Math.random() * 2.0 * span - span) < 80.0) {
                freq = 100.0;
            } else if (freq > 1000.0) {
                freq = 800.0;
            }
            this.fse.frequency.set(time, freq);
            time += durTicks;
            ++i;
        }
    }

    void startNoise(double freq) {
        this.redNoise.frequency.set(freq);
        this.redNoise.amplitude.set(0.4);
    }

    void stopNoise() {
        this.redNoise.amplitude.set(0.0);
    }

    public void handleKeyDown(int key) {
        int time = Synth.getTickCount();
        switch (key) {
            case 97: {
                this.fse.setStage(time, 0);
                break;
            }
            case 115: {
                this.fse.setStage(time, 1);
                break;
            }
            case 100: {
                this.fse.setStage(time, 2);
                break;
            }
            case 122: {
                this.fse.rate.set(0.5);
                break;
            }
            case 120: {
                this.fse.rate.set(1.0);
                break;
            }
            case 99: {
                this.fse.rate.set(2.0);
                break;
            }
            case 113: {
                this.randomFreqPattern(8, 0.1, 100.0);
                break;
            }
            case 119: {
                this.randomFreqPattern(8, 0.2, 200.0);
                break;
            }
            case 101: {
                this.randomFreqPattern(32, 0.02, 10.0);
                break;
            }
            case 114: {
                this.fse.attack();
                break;
            }
            case 116: {
                this.fse.release();
                break;
            }
            case 121: {
                this.fse.loop();
                break;
            }
            case 117: {
                this.startNoise(200.0);
                break;
            }
            case 105: {
                this.startNoise(600.0);
                break;
            }
            case 111: {
                this.startNoise(2000.0);
            }
        }
    }

    public void handleKeyUp(int key) {
        switch (key) {
            case 117: {
                this.stopNoise();
                break;
            }
            case 105: {
                this.stopNoise();
                break;
            }
            case 111: {
                this.stopNoise();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        char key = e.getKeyChar();
        if (key != this.lastKeyDown) {
            this.lastKeyDown = key;
            this.handleKeyDown(key);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        if (key >= 65 && key <= 90) {
            key += 32;
        }
        this.lastKeyDown = -1;
        this.handleKeyUp(key);
    }
}

