/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.examples.ChebyshevOscAllocator;
import com.softsynth.jsyn.examples.LinearCongruentialRandom;
import com.softsynth.jsyn.view102.SynthScope;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;

public class TJ_ChebyshevSong
extends Applet
implements Runnable {
    ChebyshevOscAllocator allocator;
    LineOut unitOut;
    SynthScope scope;
    volatile boolean go = false;
    LinearCongruentialRandom linCon;
    static final int[] scale;
    static final int MAX_NOTES = 8;
    static final int CHEBYSHEV_ORDER = 11;

    static {
        int[] nArray = new int[5];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 7;
        nArray[4] = 9;
        scale = nArray;
    }

    public static void main(String[] args) {
        TJ_ChebyshevSong applet = new TJ_ChebyshevSong();
        AppletFrame frame = new AppletFrame("TJ_ChebyshevSong", applet);
        frame.setSize(600, 500);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        this.linCon = new LinearCongruentialRandom();
        try {
            Synth.startEngine(0);
            this.allocator = new ChebyshevOscAllocator(8, 11, 1024);
            this.unitOut = new LineOut();
            this.allocator.getOutput().connect(0, this.unitOut.input, 0);
            this.allocator.getOutput().connect(0, this.unitOut.input, 1);
            this.unitOut.start();
            this.scope = new SynthScope();
            this.scope.createProbe(this.allocator.getOutput(), "Bus out", Color.yellow);
            this.scope.finish();
            this.scope.hideControls();
            this.add("Center", this.scope);
            this.getParent().validate();
            this.getToolkit().sync();
            Thread thread = new Thread(this);
            this.go = true;
            thread.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        this.go = false;
        this.removeAll();
        try {
            System.out.println("call stopEngine");
            Synth.stopEngine();
            System.out.println("returned from stopEngine");
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    double indexToFrequency(int index) {
        int octave = index / scale.length;
        int temp = index % scale.length;
        int pitch = scale[temp] + 12 * octave;
        return EqualTemperedTuning.getMIDIFrequency(pitch + 16);
    }

    @Override
    public void run() {
        int savedSeed = (int)System.currentTimeMillis();
        int ticksPerBeat = (int)(Synth.getTickRate() * 0.2);
        int advanceTime = (int)(Synth.getTickRate() * 0.5);
        int nextTime = Synth.getTickCount() + advanceTime;
        int onTime = ticksPerBeat / 2;
        int beatIndex = 0;
        try {
            do {
                if ((beatIndex & 7) == 0) {
                    if (Math.random() < 0.5) {
                        this.linCon.setSeed(savedSeed);
                    } else if (Math.random() < 0.5) {
                        savedSeed = this.linCon.getSeed();
                    }
                }
                int numNotes = this.linCon.choose(5);
                int i = 0;
                while (i < numNotes) {
                    SynthNote note = (SynthNote)this.allocator.steal(nextTime, nextTime + 2 * ticksPerBeat);
                    double frequency = this.indexToFrequency(this.linCon.choose(30));
                    note.noteOnFor(nextTime, onTime, frequency, 0.15);
                    ++i;
                }
                ++beatIndex;
                Synth.sleepUntilTick((nextTime += ticksPerBeat) - advanceTime);
            } while (this.go);
        }
        catch (SynthException e) {
            System.err.println("Song exiting. " + e);
        }
    }
}

