/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.EnvelopePoints;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthVariable;
import com.softsynth.jsyn.circuits.FMOperator;
import com.softsynth.jsyn.examples.FMLab;
import com.softsynth.jsyn.view11x.EditListener;
import com.softsynth.jsyn.view11x.EnvelopeEditor;
import com.softsynth.tools.jsyn.DecibelPortKnob;
import com.softsynth.tools.jsyn.PortKnob;
import com.softsynth.tools.view.RotaryKnob;
import com.softsynth.util.NumericOutput;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintStream;

class OperatorEditor
extends Panel
implements EditListener {
    Checkbox hearBox;
    Checkbox sustainBox;
    Checkbox[] sourceBoxes;
    Checkbox fixedBox;
    public PortKnob scaleKnob;
    public PortKnob depthKnob;
    public PortKnob indexKnob;
    public DecibelPortKnob amplitudeKnob;
    Panel knobPanel;
    FMOperator operator;
    AddUnit[] adders;
    SynthOutput output;
    SynthEnvelope envelope;
    SynthEnvelope resetEnvelope;
    public static final int SUSTAIN_END = 2;
    EnvelopeEditor envEditor;
    EnvelopePoints points;
    final int MAX_FRAMES = 16;
    FMLab myLab;
    int index;
    int sourceIndex = -1;
    boolean[] connected;

    public OperatorEditor(FMLab lab, int index) {
        this.myLab = lab;
        this.index = index;
        this.operator = new FMOperator();
        this.envelope = new SynthEnvelope(16);
        double[] data = new double[]{0.01, 0.0};
        this.resetEnvelope = new SynthEnvelope(data);
        this.operator.setEnvelope(this.envelope);
        this.operator.start();
        this.output = this.operator.output;
        this.connected = new boolean[4];
        this.adders = new AddUnit[4 - 1];
        int i = 0;
        while (i < this.adders.length) {
            this.adders[i] = new AddUnit();
            this.adders[i].start();
            if (i > 0) {
                this.adders[i - 1].output.connect(this.adders[i].inputA);
            }
            ++i;
        }
        this.adders[this.adders.length - 1].output.connect(this.operator.input);
        this.setLayout(new BorderLayout());
        this.knobPanel = new Panel();
        this.add(this.knobPanel);
        this.knobPanel.setLayout(new GridLayout(1, 0));
        this.knobPanel.add(this.setupChecks(index));
        this.knobPanel.add(this.setupEnvEditor());
        this.scaleKnob = new FMPortKnob(this.operator.scale);
        this.knobPanel.add(this.scaleKnob);
        this.scaleKnob.getKnob().setTaper(1);
        this.depthKnob = new FMPortKnob(this.operator.depth);
        this.knobPanel.add(this.depthKnob);
        this.depthKnob.getKnob().setTaper(1);
        this.indexKnob = new FMPortKnob(this.operator.index);
        this.amplitudeKnob = new DecibelPortKnob(this.operator.amplitude){

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                this.getKnob().requestFocus();
            }
        };
        this.amplitudeKnob.getKnob().addKeyListener(this.myLab);
        this.reset();
    }

    public void setSource(int idx, boolean used) {
        SynthInput port = idx == 0 ? this.adders[0].inputA : this.adders[idx - 1].inputB;
        if (used) {
            this.myLab.getNthEditor((int)idx).output.connect(port);
        } else if (this.connected[idx]) {
            port.disconnect();
        }
        this.sourceBoxes[idx].setState(used);
        this.connected[idx] = used;
    }

    public void setHeard(boolean heard) {
        if (heard) {
            this.myLab.setOperatorMix(this.index, 0.2);
            this.indexKnob.getKnob().setValue(0.0);
            this.knobPanel.remove(this.indexKnob);
            this.knobPanel.add(this.amplitudeKnob);
        } else {
            this.myLab.setOperatorMix(this.index, 0.0);
            this.amplitudeKnob.getKnob().setValue(0.0);
            this.knobPanel.remove(this.amplitudeKnob);
            this.knobPanel.add(this.indexKnob);
        }
        this.knobPanel.validate();
        this.hearBox.setState(heard);
    }

    public void setSustainIndex(int index) {
        this.envelope.setSustainLoop(index, index);
        this.sustainBox.setState(index >= 0);
    }

    public void setFixed(boolean fixed) {
        RotaryKnob knob = this.scaleKnob.getKnob();
        if (fixed) {
            this.scaleKnob.setText("frequency");
            knob.setMaximum(4000.0);
            knob.setMinimum(0.01);
            knob.setTaper(1);
        } else {
            this.scaleKnob.setText("freqMult");
            knob.setMaximum(30.0);
            knob.setMinimum(0.0);
            knob.setTaper(0);
        }
        this.fixedBox.setState(fixed);
    }

    Panel setupChecks(int index) {
        Font bigFont;
        Panel checkPanel = new Panel();
        Label aLabel = new Label("Op#" + index);
        checkPanel.add(aLabel);
        aLabel.setForeground(Color.red);
        Font smallFont = aLabel.getFont();
        if (smallFont != null && (bigFont = new Font(smallFont.getName(), 1, smallFont.getSize() * 2)) != null) {
            aLabel.setFont(bigFont);
        }
        this.sourceBoxes = new Checkbox[4];
        int i = 0;
        while (i < 4) {
            this.sourceBoxes[i] = new Checkbox(Integer.toString(i), false);
            this.sourceBoxes[i].addKeyListener(this.myLab);
            this.sourceBoxes[i].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String s = (String)e.getItem();
                    int idx = Integer.parseInt(s);
                    OperatorEditor.this.setSource(idx, OperatorEditor.this.sourceBoxes[idx].getState());
                }
            });
            checkPanel.add(this.sourceBoxes[i]);
            ++i;
        }
        this.hearBox = new Checkbox("Hear", false);
        this.hearBox.addKeyListener(this.myLab);
        this.hearBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OperatorEditor.this.setHeard(OperatorEditor.this.hearBox.getState());
            }
        });
        checkPanel.add(this.hearBox);
        this.sustainBox = new Checkbox("Sust", false);
        this.sustainBox.addKeyListener(this.myLab);
        this.sustainBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OperatorEditor.this.setSustainIndex(OperatorEditor.this.sustainBox.getState() ? 2 : -1);
            }
        });
        checkPanel.add(this.sustainBox);
        this.fixedBox = new Checkbox("Fixed", false);
        this.fixedBox.addKeyListener(this.myLab);
        this.fixedBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OperatorEditor.this.setFixed(OperatorEditor.this.fixedBox.getState());
            }
        });
        checkPanel.add(this.fixedBox);
        return checkPanel;
    }

    EnvelopeEditor setupEnvEditor() {
        this.envEditor = new EnvelopeEditor();
        this.envEditor.addKeyListener(this.myLab);
        this.envEditor.setBackground(Color.cyan.brighter());
        this.envEditor.setVerticalBarsEnabled(true);
        this.envEditor.setVerticalBarSpacing(0.2);
        this.envEditor.setMaximumXRange(20.0);
        this.envEditor.addEditListener(this);
        this.points = new EnvelopePoints();
        this.points.setName("amplitude");
        this.envEditor.setPoints(this.points);
        this.envEditor.setMaxPoints(16);
        double[] dar = new double[]{0.1, 1.0, 0.2, 0.5, 0.5, 0.5, 0.5, 0.0};
        this.setContour(dar);
        return this.envEditor;
    }

    public void setContour(double[] dar) {
        this.points.removeAllElements();
        int i = 0;
        while (i < dar.length / 2) {
            this.points.add(dar[i * 2], dar[i * 2 + 1]);
            ++i;
        }
        this.updateEnvelope();
        this.envEditor.repaint();
    }

    @Override
    public void objectEdited(Object editor, Object objPoints) {
        this.updateEnvelope();
    }

    public void updateEnvelope() {
        int numFrames = this.points.size();
        int i = 0;
        while (i < numFrames) {
            this.envelope.write(i, this.points.getPoint(i), 0, 1);
            ++i;
        }
        double lastVal = 0.0;
        if (numFrames > 0) {
            lastVal = this.points.getPoint(numFrames - 1)[1];
        }
        double[] filler = new double[]{0.0, lastVal};
        int i2 = numFrames;
        while (i2 < this.envelope.getNumFrames()) {
            this.envelope.write(i2, filler, 0, 1);
            ++i2;
        }
    }

    public void noteOn(double frequency) {
        this.operator.frequency.set(this.fixedBox.getState() ? 1.0 : frequency);
        this.operator.setStage(Synth.getTickCount(), 0);
    }

    public void noteOff() {
        this.operator.setStage(Synth.getTickCount(), 1);
    }

    public void reset() {
        if (this.resetEnvelope != null) {
            this.operator.envelopePort.queue(this.resetEnvelope);
        }
        this.setSustainIndex(-1);
        this.setFixed(false);
        int i = 0;
        while (i < this.connected.length) {
            this.setSource(i, false);
            ++i;
        }
    }

    public void dumpSource(PrintStream ps, int idx) {
        int i = 0;
        while (i < 4) {
            if (this.sourceBoxes[i].getState()) {
                ps.println("\teditor.setSource( " + i + ", true );");
            }
            ++i;
        }
        ps.println("\teditor.setHeard( " + this.hearBox.getState() + " );");
        ps.println("\teditor.setFixed( " + this.fixedBox.getState() + " );");
        ps.println("\teditor.setSustainIndex( " + this.envelope.getSustainBegin() + " );");
        ps.println("\teditor.scaleKnob.setValue( " + this.scaleKnob.getKnob().getValue() + " );");
        ps.println("\teditor.depthKnob.setValue( " + this.depthKnob.getKnob().getValue() + " );");
        ps.println("\teditor.indexKnob.setValue( " + this.indexKnob.getKnob().getValue() + " );");
        ps.println("\teditor.amplitudeKnob.setValue( " + this.amplitudeKnob.getKnob().getValue() + " );");
        ps.println("\tdouble dar" + idx + "[] = {");
        int numFrames = this.points.size();
        int i2 = 0;
        while (i2 < numFrames) {
            double[] dar = this.points.getPoint(i2);
            ps.print("\t\t" + NumericOutput.doubleToString(dar[0], 1, 4) + ", " + NumericOutput.doubleToString(dar[1], 1, 3));
            if (i2 < numFrames - 1) {
                ps.println(",");
            }
            ++i2;
        }
        ps.println(" };");
        ps.println("\teditor.setContour( dar" + idx + ");");
    }

    class FMPortKnob
    extends PortKnob {
        public FMPortKnob(SynthVariable port) {
            super(port);
            this.getKnob().addKeyListener(OperatorEditor.this.myLab);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            this.getKnob().requestFocus();
        }
    }
}

