/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;

class FeedbackFM
extends SynthNote {
    SineOscillator modOsc;
    SineOscillator carOsc;
    AddUnit adder;
    MultiplyAddUnit feedbackScaler;
    public SynthInput modFrequency;
    public SynthInput modAmplitude;
    public SynthInput feedbackDepth;

    public FeedbackFM() throws SynthException {
        this.makeCircuit();
        this.addAllPorts();
    }

    void makeCircuit() {
        this.modOsc = new SineOscillator();
        this.add(this.modOsc);
        this.carOsc = new SineOscillator();
        this.add(this.carOsc);
        this.adder = new AddUnit();
        this.add(this.adder);
        this.feedbackScaler = new MultiplyAddUnit();
        this.add(this.feedbackScaler);
        this.modOsc.output.connect(this.adder.inputB);
        this.adder.output.connect(this.carOsc.frequency);
        this.carOsc.output.connect(this.feedbackScaler.inputB);
        this.feedbackScaler.output.connect(this.modOsc.frequency);
        this.frequency = this.adder.inputA;
        this.amplitude = this.carOsc.amplitude;
        this.feedbackDepth = this.feedbackScaler.inputA;
        this.modFrequency = this.feedbackScaler.inputC;
        this.modAmplitude = this.modOsc.amplitude;
        this.output = this.carOsc.output;
        this.frequency.setSignalType(2);
        this.feedbackDepth.setSignalType(2);
        this.modFrequency.setSignalType(2);
        this.modAmplitude.setSignalType(2);
        this.modFrequency.setup(0.0, 600.0, 6000.0);
        this.modAmplitude.setup(0.0, 200.0, 5000.0);
        this.frequency.setup(0.0, 300.0, 2000.0);
        this.feedbackDepth.setup(0.0, 0.0, 6000.0);
        this.amplitude.setup(0.0, 0.5, 1.0);
    }

    void addAllPorts() {
        this.addPort(this.modFrequency, "modFrequency");
        this.addPort(this.modAmplitude, "modAmplitude");
        this.addPort(this.frequency, "frequency");
        this.addPort(this.feedbackDepth, "feedbackDepth");
        this.addPort(this.amplitude);
        this.addPort(this.output);
    }
}

