/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.debug;

import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.circuits.RingModBell;
import java.applet.Applet;

public class LoudRingModBell
extends Applet {
    private static final long serialVersionUID = 1L;
    RingModBell synthCircuit;
    LineOut out;

    @Override
    public void start() {
        Synth.startEngine(0);
        this.synthCircuit = new RingModBell();
        this.out = new LineOut();
        this.synthCircuit.output.connect(0, this.out.input, 0);
        this.synthCircuit.output.connect(0, this.out.input, 1);
        this.synthCircuit.frequency.set(880.0);
        this.out.start();
        this.synthCircuit.start();
        int jsynNow = Synth.getTickCount();
        int duration = (int)(Synth.getTickRate() * 0.5);
        double delta_freq = 100.0;
        double min_freq = 500.0;
        double max_freq = 2000.0;
        double freq = min_freq;
        int timeStampForThisEvent = jsynNow;
        while (freq < max_freq) {
            System.out.println("freq = " + freq);
            this.synthCircuit.modIndex.set(timeStampForThisEvent, 43.0);
            this.synthCircuit.frequency.set(timeStampForThisEvent, freq);
            this.synthCircuit.setStage(timeStampForThisEvent, 0);
            this.synthCircuit.setStage(timeStampForThisEvent + duration / 2, 1);
            freq += delta_freq;
            Synth.sleepUntilTick((timeStampForThisEvent += duration) - duration / 4);
        }
        System.out.println("Finished scheduling lots of note changes.");
    }

    @Override
    public void stop() {
        System.out.println("Stopping JSyn engine.");
        Synth.stopEngine();
    }
}

