/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import junit.framework.TestCase;

public class TestSleep
extends TestCase {
    public void testNonRealSleep() {
        Synth.startEngine(4);
        this.checkSleepSequence();
        Synth.stopEngine();
    }

    public void testRealSleep() {
        try {
            Synth.startEngine(0);
            this.checkSleepSequence();
        }
        finally {
            TestSleep.assertEquals("Calls to startEngine/stopEngine not balanced.", 1, Synth.getSharedContext().getOpenCount());
            Synth.stopEngine();
        }
    }

    private void checkSleepSequence() {
        Synth.sleepForTicks(500);
        this.checkBasicSleep(2);
        this.checkBasicSleep(40);
        this.checkBasicSleep(200);
    }

    private void checkBasicSleep(int duration) {
        int maxLazy = 80;
        int startTick = Synth.getTickCount();
        int alarmTime = startTick + duration;
        Synth.sleepUntilTick(alarmTime);
        int wakeTime = Synth.getTickCount();
        System.out.println("duration = " + duration + ", alarm at " + alarmTime + ", woke at " + wakeTime);
        TestSleep.assertTrue("sleep for a while", wakeTime >= alarmTime);
        TestSleep.assertTrue("don't sleep too long, duration = " + duration, wakeTime < alarmTime + 80);
    }
}

