/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.PitchDetector;
import com.softsynth.jsyn.SawtoothOscillator;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.SquareOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthDistributor;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOscillator;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthSound;
import junit.framework.TestCase;

public class TestPitchDetector
extends TestCase {
    final double[] FREQ_SET = new double[]{110.0, 210.0, 410.0, 810.0, 1700.0};

    @Override
    protected void setUp() throws Exception {
        Synth.startEngine(4);
    }

    @Override
    protected void tearDown() throws Exception {
        Synth.stopEngine();
    }

    public void testSines() {
        SineOscillator osc = new SineOscillator();
        this.checkFrequencies(this.FREQ_SET, osc);
    }

    public void testSquares() {
        SquareOscillator osc = new SquareOscillator();
        this.checkFrequencies(this.FREQ_SET, osc, 2.0, 10.0, 500.0);
    }

    public void testManySines1() {
        double[] partials = new double[]{1.0, 0.0, 0.0};
        double[] amplitudes = new double[]{1.0, 0.0, 0.0};
        ManySines osc = new ManySines(partials, amplitudes);
        this.checkFrequencies(this.FREQ_SET, osc);
    }

    public void testManySines2() {
        double[] partials = new double[]{0.0, 1.0, 0.0};
        double[] amplitudes = new double[]{0.0, 1.0, 0.0};
        ManySines osc = new ManySines(partials, amplitudes);
        this.checkFrequencies(this.FREQ_SET, osc);
    }

    public void testManySines3() {
        double[] partials = new double[]{0.0, 0.0, 1.0};
        double[] amplitudes = new double[]{0.0, 0.0, 1.0};
        ManySines osc = new ManySines(partials, amplitudes);
        this.checkFrequencies(this.FREQ_SET, osc);
    }

    public void testDecliningPartials() {
        double[] partials = new double[]{1.0, 2.0, 3.0, 4.0};
        double[] amplitudes = new double[]{0.9, 0.6, 0.3, 0.2};
        ManySines osc = new ManySines(partials, amplitudes);
        this.checkFrequencies(this.FREQ_SET, osc);
    }

    public void testEqualPartials() {
        double[] partials = new double[]{1.0, 2.0, 3.0, 4.0};
        double[] amplitudes = new double[]{0.5, 0.5, 0.4, 0.4};
        ManySines osc = new ManySines(partials, amplitudes);
        this.checkFrequencies(this.FREQ_SET, osc);
    }

    public void testLotsOfPartials() {
        int numPartials = 10;
        double[] partials = new double[numPartials];
        double[] amplitudes = new double[numPartials];
        int i = 0;
        while (i < numPartials) {
            int harmonic = i + 1;
            partials[i] = harmonic;
            amplitudes[i] = 0.8 / (double)harmonic;
            ++i;
        }
        ManySines osc = new ManySines(partials, amplitudes);
        double[] freqs = new double[]{210.0, 410.0, 810.0};
        this.checkFrequencies(this.FREQ_SET, osc, 1.0, 0.8, 12.0);
    }

    public void testEnharmonicPartials() {
        double[] freqs = new double[]{210.0, 410.0, 810.0};
        double[] partials = new double[]{1.0, 2.05, 2.937, 4.3};
        double[] amplitudes = new double[]{0.9, 0.1, 0.1, 0.1};
        ManySines osc = new ManySines(partials, amplitudes);
        this.checkFrequencies(freqs, osc, 5.0, 0.25, 1.5);
    }

    private void checkFrequencies(double[] freqs, SynthSound osc) {
        this.checkFrequencies(freqs, osc, 1.0, 0.5, 8.0);
    }

    private void checkFrequencies(double[] freqs, SynthSound osc, double freqTolerancePercent, double minConfidence, double maxConfidence) {
        System.out.println("synth = " + osc);
        PitchDetector detector = new PitchDetector();
        osc.start();
        detector.start();
        ((SynthOutput)osc.findNamedPort("Output")).connect(detector.input);
        double[] dArray = freqs;
        int n = freqs.length;
        int n2 = 0;
        while (n2 < n) {
            double expected = dArray[n2];
            ((SynthInput)osc.findNamedPort("Frequency")).set(expected);
            double actual = 0.0;
            double confidence = 0.0;
            int i = 0;
            while (i < 4) {
                Synth.sleepForTicks(20);
                actual = Synth.getFrameRate() / detector.period.get();
                confidence = detector.confidence.get();
                System.out.format("expected = %10.4f, actual = %10.4f, confidence = %10.4f\n", expected, actual, confidence);
                ++i;
            }
            double freqTolerance = expected * freqTolerancePercent / 100.0;
            TestPitchDetector.assertEquals("match frequency", expected, actual, freqTolerance);
            TestPitchDetector.assertTrue("for freq = " + expected + ", sadly confidence  " + confidence + " not > " + minConfidence, confidence > minConfidence);
            ++n2;
        }
    }

    public void testAnalyzeSawtooth() throws InterruptedException {
        double freq = 978.0;
        SawtoothOscillator osc = new SawtoothOscillator();
        PitchDetector detector = new PitchDetector();
        osc.frequency.set(freq);
        osc.output.connect(detector.input);
        osc.start();
        detector.start();
        long startAt = System.currentTimeMillis();
        Synth.sleepForTicks((int)Synth.getTickRate());
        long endAt = System.currentTimeMillis();
        System.out.println("Calculated at " + (double)(endAt - startAt) / 10.0 + "% of realtime.");
        double expectedPeriod = Synth.getFrameRate() / freq;
        System.out.println("expectedPeriod = " + expectedPeriod);
        TestPitchDetector.assertEquals("Sawtooth period", expectedPeriod, detector.period.get(), 1.0);
    }

    class ManySines
    extends SynthCircuit {
        SynthDistributor frequency = new SynthDistributor("Frequency");
        SynthOutput output;
        SynthOscillator[] sines;
        MultiplyUnit[] multipliers;
        AddUnit[] adders;

        ManySines(double[] partials, double[] amplitudes) {
            this.addPort(this.frequency);
            TestPitchDetector.assertEquals(partials.length, amplitudes.length);
            int numOsc = partials.length;
            this.sines = new SynthOscillator[numOsc];
            this.multipliers = new MultiplyUnit[numOsc];
            this.adders = new AddUnit[numOsc];
            SynthOutput previousOutput = null;
            int i = 0;
            while (i < numOsc) {
                this.sines[i] = new SineOscillator();
                this.add(this.sines[i]);
                this.multipliers[i] = new MultiplyUnit();
                this.add(this.multipliers[i]);
                this.frequency.connect(this.multipliers[i].inputA);
                this.multipliers[i].inputB.set(partials[i]);
                this.sines[i].amplitude.set(amplitudes[i]);
                this.multipliers[i].output.connect(this.sines[i].frequency);
                if (i == 0) {
                    previousOutput = this.sines[i].output;
                } else {
                    this.adders[i] = new AddUnit();
                    this.add(this.adders[i]);
                    previousOutput.connect(this.adders[i].inputA);
                    this.sines[i].output.connect(this.adders[i].inputB);
                    previousOutput = this.adders[i].output;
                }
                ++i;
            }
            this.output = this.adders[numOsc - 1].output;
            this.addPort(this.output);
        }
    }
}

