/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;
import junit.framework.TestCase;

public class TestCircuit
extends TestCase {
    SynthContext context;
    SimpleCircuit circuit;
    float a = 2.0f;
    float b = 3.0f;
    float c = 5.0f;

    @Override
    protected void setUp() throws Exception {
        this.context = new SynthContext();
        this.context.initialize();
        this.context.start(4);
        this.circuit = new SimpleCircuit(this.context);
        this.circuit.a.set(this.a);
        this.circuit.b.set(this.b);
        this.circuit.c.set(this.c);
    }

    @Override
    protected void tearDown() throws Exception {
        this.context.stop();
    }

    public void testCircuitPorts() {
        TestCircuit.assertEquals("number of ports", 4, this.circuit.getNumPorts());
        TestCircuit.assertEquals("find named port on circuit", this.circuit.a, this.circuit.findNamedPort("A"));
        TestCircuit.assertEquals("find named port on circuit", this.circuit.output, this.circuit.findNamedPort("Output"));
    }

    public void testStart() {
        this.context.sleepForTicks(1);
        TestCircuit.assertEquals("circuit stopped so should still have default output", 0.0, this.circuit.output.get(), 1.0E-4);
        this.circuit.start();
        this.context.sleepForTicks(1);
        TestCircuit.assertEquals("circuit started so should run internal units", (double)(this.a * this.b + this.c), this.circuit.output.get(), 1.0E-4);
        this.circuit.stop();
        this.circuit.a.set(15.0);
        this.circuit.b.set(23.0);
        this.circuit.c.set(97.0);
        this.context.sleepForTicks(1);
        TestCircuit.assertEquals("circuit stopped so should have old result", (double)(this.a * this.b + this.c), this.circuit.output.get(), 1.0E-4);
    }

    public void testLateAddition() {
        this.circuit.start();
        boolean b = true;
        try {
            this.circuit.add(new AddUnit(this.context));
            b = false;
        }
        catch (SynthException e) {
            System.out.println("Caught expected error = " + e);
        }
        TestCircuit.assertTrue("late add() should cause exception", b);
        try {
            this.circuit.addPort(this.circuit.multiplier.output, "Intermediate");
            b = false;
        }
        catch (SynthException e) {
            System.out.println("Caught unexpected error = " + e);
        }
        TestCircuit.assertEquals("addPort() should not cause exception", false, b);
    }

    class SimpleCircuit
    extends SynthCircuit {
        AddUnit adder;
        MultiplyUnit multiplier;
        SynthInput a;
        SynthInput b;
        SynthInput c;
        SynthOutput output;

        public SimpleCircuit(SynthContext context) {
            super(context);
            this.adder = new AddUnit(context);
            this.add(this.adder);
            this.multiplier = new MultiplyUnit(context);
            this.add(this.multiplier);
            this.multiplier.output.connect(this.adder.inputA);
            this.a = this.multiplier.inputA;
            this.addPort(this.a, "A");
            this.b = this.multiplier.inputB;
            this.addPort(this.b, "B");
            this.c = this.adder.inputB;
            this.addPort(this.c, "C");
            this.output = this.adder.output;
            this.addPort(this.output);
        }
    }
}

