/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSound;

public class SynthUnit
extends SynthSound {
    public SynthUnit(SynthContext context, String unitName, int calculationRate, int param) throws SynthException {
        super(context);
        int unitHash = Synth.hashName(unitName);
        this.name = unitName;
        this.peerToken = context.createUnit(unitHash, calculationRate, param);
        if (Synth.verbosity >= 1) {
            System.out.println("new SynthUnit(" + unitName + ",, " + param + " ) => " + Integer.toHexString(this.peerToken));
        }
        if (this.peerToken < 0) {
            context.reclaim();
            this.peerToken = context.createUnit(unitHash, calculationRate, param);
            if (this.peerToken < 0) {
                throw new SynthException(this.peerToken, unitName, param);
            }
        }
    }

    public SynthUnit(SynthContext synthContext, String unitName, int calculationRate) throws SynthException {
        this(synthContext, unitName, calculationRate, 0);
    }

    public SynthUnit(String unitName, int calculationRate, int param) throws SynthException {
        this(Synth.getSharedContext(), unitName, calculationRate, param);
    }

    public SynthUnit(String unitName, int calculationRate) throws SynthException {
        this(unitName, calculationRate, 0);
    }
}

