/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.CuePoint;
import com.softsynth.jsyn.ParseIFF;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthChannelData;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import java.io.IOException;
import java.io.InputStream;

public class SynthSample
extends SynthChannelData {
    public static final int UNRECOGNIZED = 0;
    public static final int AIFF = 1;
    public static final int WAV = 2;
    public byte[] byteData;
    int channelsPerFrame;
    double recordedSampleRate = 44100.0;
    double lowestAmplitude = 0.0;
    double highestAmplitude = 1.0;
    double lowestFrequency = 0.0;
    double highestFrequency = 88200.0;
    double baseFrequency = 440.0;
    boolean ifLoadData;
    long dataPosition;
    ParseIFF parser;

    public SynthSample(SynthContext synthContext) {
        super(synthContext, 0);
    }

    public SynthSample() {
        this(Synth.getSharedContext());
    }

    public SynthSample(SynthContext synthContext, int maxFrames, int channelsPerFrame) throws SynthException {
        super(synthContext, maxFrames);
        this.allocate(maxFrames, channelsPerFrame);
    }

    public SynthSample(int maxFrames, int channelsPerFrame) throws SynthException {
        this(Synth.getSharedContext(), maxFrames, channelsPerFrame);
    }

    public SynthSample(SynthContext synthContext, int maxFrames) {
        this(synthContext, maxFrames, 1);
    }

    public static int getFileType(String fileName) {
        if (fileName.endsWith(".aiff") || fileName.endsWith(".aif") || fileName.endsWith(".AIFF") || fileName.endsWith(".AIF")) {
            return 1;
        }
        if (fileName.endsWith(".wave") || fileName.endsWith(".wav") || fileName.endsWith(".WAVE") || fileName.endsWith(".WAV")) {
            return 2;
        }
        return 0;
    }

    public void allocate(int numFrames, int channelsPerFrame) throws SynthException {
        this.delete();
        this.channelsPerFrame = channelsPerFrame;
        this.numFrames = numFrames;
        this.peerToken = this.context.createSample(numFrames, channelsPerFrame);
        if (Synth.verbosity >= 1) {
            System.out.println("SynthSample.allocate(" + numFrames + ", " + channelsPerFrame + " ) => " + Integer.toHexString(this.peerToken));
        }
        if (this.peerToken < 0) {
            throw new SynthException(this.peerToken, numFrames);
        }
    }

    public SynthSample(int numFrames) throws SynthException {
        this(numFrames, 1);
    }

    public void write(int firstSampleFrame, short[] data, int firstDataIndex, int numFrames) throws SynthException {
        int result = this.context.writeSample(this.peerToken, firstSampleFrame, numFrames, data, firstDataIndex, data.length);
        if (result < 0) {
            throw new SynthException(result, firstSampleFrame);
        }
    }

    public void write(short[] data) throws SynthException {
        this.write(0, data, 0, data.length / this.channelsPerFrame);
    }

    public void clear(int firstSampleFrame, int numFrames) {
        int CLEAR_SIZE = 64;
        short[] zeros = new short[64];
        int numClearFrames = 64 / this.channelsPerFrame;
        int numFullWrites = numFrames / numClearFrames;
        int frameIndex = firstSampleFrame;
        int i = 0;
        while (i < numFullWrites) {
            this.write(frameIndex, zeros, 0, numClearFrames);
            frameIndex += numClearFrames;
            ++i;
        }
        int remainingFrames = numFrames - numClearFrames * numFullWrites;
        if (remainingFrames > 0) {
            this.write(frameIndex, zeros, 0, remainingFrames);
        }
    }

    public void clear() {
        this.clear(0, this.getNumFrames());
    }

    public void read(int firstSampleFrame, short[] data, int firstDataIndex, int numFrames) throws SynthException {
        int result = this.context.readSample(this.peerToken, firstSampleFrame, numFrames, data, firstDataIndex, data.length);
        if (result < 0) {
            throw new SynthException(result, firstSampleFrame);
        }
    }

    public void read(short[] data) throws SynthException {
        this.read(0, data, 0, data.length / this.channelsPerFrame);
    }

    public void setSampleRate(double sampleRate) {
        this.recordedSampleRate = sampleRate;
    }

    public double getSampleRate() {
        return this.recordedSampleRate;
    }

    public void setBaseFrequency(double baseFrequency) {
        this.baseFrequency = baseFrequency;
    }

    public double getBaseFrequency() {
        return this.baseFrequency;
    }

    public int getChannelsPerFrame() {
        return this.channelsPerFrame;
    }

    public void setLowFrequency(double lowestFrequency) {
        this.lowestFrequency = lowestFrequency;
    }

    public void setHighFrequency(double highestFrequency) {
        this.highestFrequency = highestFrequency;
    }

    public void setLowAmplitude(double lowestAmplitude) {
        this.lowestAmplitude = lowestAmplitude;
    }

    public void setHighAmplitude(double highestAmplitude) {
        this.highestAmplitude = highestAmplitude;
    }

    public String dump() {
        String str = "Sample";
        str = String.valueOf(str) + "\n     numChannels = " + this.channelsPerFrame;
        str = String.valueOf(str) + "\n     sampleRate = " + this.recordedSampleRate;
        str = String.valueOf(str) + "\n     baseFrequency = " + this.baseFrequency;
        str = String.valueOf(str) + "\n     lowestFrequency = " + this.lowestFrequency;
        str = String.valueOf(str) + "\n     highestFrequency = " + this.highestFrequency;
        if (this.cuePoints != null) {
            str = String.valueOf(str) + "\n   Cue Points:";
            int k = 0;
            while (k < this.cuePoints.size()) {
                CuePoint cue = (CuePoint)this.cuePoints.elementAt(k);
                str = String.valueOf(str) + "\n    " + cue.getID() + ", " + cue.getPosition();
                ++k;
            }
        }
        return str;
    }

    public long getOffset() {
        return this.dataPosition;
    }

    public void load(InputStream stream) throws SynthException, IOException {
        this.load(stream, true);
    }

    public void load(InputStream stream, boolean ifLoadData) throws SynthException, IOException {
        short[] shortData = this.loadShorts(stream, ifLoadData);
        if (shortData != null) {
            this.allocate(this.numFrames, this.channelsPerFrame);
            this.write(shortData);
        }
    }

    public short[] loadShorts(InputStream stream, boolean ifLoadData) throws SynthException, IOException {
        return null;
    }

    short[] convertLittleBytesToShorts() {
        int numShorts = this.byteData.length / 2;
        short[] shortData = new short[numShorts];
        int i = 0;
        while (i < numShorts) {
            shortData[i] = (short)(this.byteData[i * 2] & 0xFF | this.byteData[i * 2 + 1] << 8);
            ++i;
        }
        return shortData;
    }

    short[] convertUnsignedBytesToShorts() {
        int numShorts = this.byteData.length;
        short[] shortData = new short[numShorts];
        int i = 0;
        while (i < numShorts) {
            shortData[i] = (short)(this.byteData[i] + 128 << 8);
            ++i;
        }
        return shortData;
    }

    short[] convertBigBytesToShorts() {
        int numShorts = this.byteData.length / 2;
        short[] shortData = new short[numShorts];
        int i = 0;
        while (i < numShorts) {
            shortData[i] = (short)(this.byteData[i * 2 + 1] & 0xFF | this.byteData[i * 2] << 8);
            ++i;
        }
        return shortData;
    }

    public synchronized long getNumBytesRead() {
        if (this.parser != null) {
            return this.parser.getOffset();
        }
        return 0L;
    }

    public synchronized long getFileSize() {
        if (this.parser != null) {
            return this.parser.getFileSize();
        }
        return 0L;
    }
}

