/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSound;

public class SynthPort {
    SynthSound sound;
    String name;
    String alias;
    int peerToken;
    int portHash;

    SynthPort(SynthSound sound, String name) throws SynthException {
        this.sound = sound;
        this.name = name;
        this.alias = name;
        this.portHash = Synth.hashName(name);
        if (sound != null) {
            this.peerToken = sound.peerToken;
            sound.addPort(this);
        } else {
            this.peerToken = 0;
        }
    }

    public String toString() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getName() {
        return this.name;
    }

    public SynthSound getSound() {
        return this.sound;
    }

    public void setSignalType(int signalType, int partIndex) throws SynthException {
        int nativeError = this.sound.context.setPortSignalType(this.peerToken, this.portHash, partIndex, signalType);
        if (nativeError < 0) {
            throw new SynthException(nativeError, this.name, partIndex, signalType);
        }
    }

    public void setSignalType(int signalType) throws SynthException {
        this.setSignalType(signalType, 0);
    }

    public int getSignalType(int partIndex) throws SynthException {
        int nativeError = this.sound.context.getPortSignalType(this.peerToken, this.portHash, partIndex);
        if (nativeError < 0) {
            throw new SynthException(nativeError, this.name, partIndex);
        }
        return nativeError;
    }

    public int getSignalType() throws SynthException {
        return this.getSignalType(0);
    }

    public void setSignalType(SynthPort port) throws SynthException {
        this.setSignalType(port.getSignalType());
    }

    public int getNumParts() throws SynthException {
        int nativeError = this.sound.context.getNumParts(this.peerToken, this.portHash);
        if (nativeError < 0) {
            throw new SynthException(nativeError, this.name, this.portHash);
        }
        return nativeError;
    }

    void addConnection(SynthPort port) {
    }

    void removeConnection(SynthPort port) {
    }

    static void connectUnits(SynthPort outPort, int outIndex, SynthPort inPort, int inIndex) throws SynthException {
        int nativeError;
        if (Synth.verbosity >= 1) {
            System.out.println("jsyn.SynthPort: connect( " + Integer.toHexString(outPort.peerToken) + ", " + outPort.name + ", " + outIndex + ", " + Integer.toHexString(inPort.peerToken) + ", " + inPort.name + ", " + inIndex + " )");
        }
        if ((nativeError = outPort.sound.context.connectUnits(outPort.peerToken, outPort.portHash, outIndex, inPort.peerToken, inPort.portHash, inIndex)) < 0) {
            throw new SynthException(nativeError, outPort.name, outPort.peerToken, inPort.peerToken);
        }
    }

    static void disconnectUnits(SynthPort port, int index) throws SynthException {
        int err;
        if (Synth.verbosity >= 1) {
            System.out.println("jsyn.SynthPort: DISconnect( " + Integer.toHexString(port.peerToken) + ", " + port.name + ", " + index + " )");
        }
        if ((err = port.sound.context.disconnectUnits(port.peerToken, port.portHash, index)) < 0) {
            throw new SynthException(err, port.name, port.peerToken, index);
        }
    }
}

