/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthChannelData;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;

public class SynthEnvelope
extends SynthChannelData {
    public SynthEnvelope(int maxFrames) throws SynthException {
        this(Synth.getSharedContext(), maxFrames);
    }

    public SynthEnvelope(SynthContext context, int maxFrames) throws SynthException {
        super(context, maxFrames);
        this.peerToken = context.createEnvelope(maxFrames);
        if (this.peerToken < 0) {
            throw new SynthException(this.peerToken, maxFrames);
        }
    }

    public SynthEnvelope(SynthContext synthContext, double[] data) throws SynthException {
        this(synthContext, data.length / 2);
        this.write(0, data, 0, this.maxFrames);
    }

    public SynthEnvelope(double[] data) throws SynthException {
        this(Synth.getSharedContext(), data);
    }

    public void write(int firstEnvelopeFrame, double[] data, int firstDataFrame, int numFrames) throws SynthException {
        int result = this.context.writeEnvelope(this.peerToken, firstEnvelopeFrame, numFrames, data, firstDataFrame, data.length);
        if (result < 0) {
            throw new SynthException(result, this.peerToken, firstEnvelopeFrame);
        }
    }

    public void write(double[] data) throws SynthException {
        this.write(0, data, 0, data.length / 2);
    }

    public void read(int firstEnvelopeFrame, double[] data, int firstDataFrame, int numFrames) throws SynthException {
        int result = this.context.readEnvelope(this.peerToken, firstEnvelopeFrame, numFrames, data, firstDataFrame, data.length);
        if (result < 0) {
            throw new SynthException(result, this.peerToken, firstEnvelopeFrame);
        }
    }

    public void read(double[] data) throws SynthException {
        this.read(0, data, 0, data.length / 2);
    }
}

