/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthChannelData;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthPort;
import com.softsynth.jsyn.SynthSound;

public class SynthDataQueue
extends SynthPort {
    SynthDataQueue(SynthSound sound, String name) throws SynthException {
        super(sound, name);
    }

    SynthDataQueue(SynthSound sound) throws SynthException {
        super(sound, "Data");
    }

    public void clear() throws SynthException {
        int nativeError;
        if (Synth.verbosity >= 2) {
            System.out.println("SynthDataQueue[" + Integer.toHexString(this.sound.peerToken) + "].clear( " + Integer.toHexString(this.peerToken) + ")" + " at " + this.sound.context.getTickCount());
        }
        if ((nativeError = this.sound.context.clearDataQueue(this.peerToken, this.portHash)) < 0) {
            throw new SynthException(nativeError, this.name, this.peerToken);
        }
    }

    public void clear(int time) throws SynthException {
        int nativeError;
        if (Synth.verbosity >= 2) {
            System.out.println("SynthDataQueue[" + Integer.toHexString(this.sound.peerToken) + "].clear( t=" + time + ", " + Integer.toHexString(this.peerToken) + ")");
        }
        if ((nativeError = this.sound.context.clearDataQueueAt(time, this.peerToken, this.portHash)) < 0) {
            throw new SynthException(nativeError, this.name, this.peerToken);
        }
    }

    public void queue(SynthChannelData channelData, int startFrame, int numFrames, int flags) throws SynthException {
        int nativeError;
        int channelDataToken = channelData.getPeer();
        if (Synth.verbosity >= 2) {
            System.out.println("SynthDataQueue[" + Integer.toHexString(this.sound.peerToken) + "].queue(" + Integer.toHexString(channelDataToken) + ", " + startFrame + ", " + numFrames + ", " + flags + ")" + " at " + this.sound.context.getTickCount());
        }
        if ((nativeError = this.sound.context.queueData(this.peerToken, this.portHash, channelDataToken, startFrame, numFrames, flags)) < 0) {
            throw new SynthException(nativeError, this.name, this.peerToken, startFrame);
        }
    }

    public void queue(SynthChannelData channelData, int startFrame, int numFrames) throws SynthException {
        this.queue(channelData, startFrame, numFrames, 0);
    }

    public void queueLoop(SynthChannelData channelData, int startFrame, int numFrames) throws SynthException {
        int nativeError;
        int channelDataToken = channelData.getPeer();
        if (Synth.verbosity >= 2) {
            System.out.println("SynthDataQueue[" + Integer.toHexString(this.sound.peerToken) + "].queueLoop(" + Integer.toHexString(channelDataToken) + ", " + startFrame + ", " + numFrames + ")");
        }
        if ((nativeError = this.sound.context.queueData(this.peerToken, this.portHash, channelDataToken, startFrame, numFrames, 8)) < 0) {
            throw new SynthException(nativeError, this.name, startFrame, numFrames);
        }
    }

    public void queue(int time, SynthChannelData channelData, int startFrame, int numFrames, int flags) throws SynthException {
        int nativeError;
        int channelDataToken = channelData.getPeer();
        if (Synth.verbosity >= 2) {
            System.out.println("SynthDataQueue[" + Integer.toHexString(this.sound.peerToken) + "].queue( t= " + time + ", " + Integer.toHexString(channelDataToken) + ", " + startFrame + ", " + numFrames + ")");
        }
        if ((nativeError = this.sound.context.queueDataAt(time, this.peerToken, this.portHash, channelDataToken, startFrame, numFrames, flags)) < 0) {
            throw new SynthException(nativeError, this.name, startFrame, numFrames);
        }
    }

    public void queue(int time, SynthChannelData channelData, int startFrame, int numFrames) throws SynthException {
        this.queue(time, channelData, startFrame, numFrames, 0);
    }

    public void queueLoop(int time, SynthChannelData channelData, int startFrame, int numFrames) throws SynthException {
        int nativeError;
        int channelDataToken = channelData.getPeer();
        if (Synth.verbosity >= 2) {
            System.out.println("SynthDataQueue[" + Integer.toHexString(this.sound.peerToken) + "].queueLoop( t= " + time + ", " + Integer.toHexString(channelDataToken) + ", " + startFrame + ", " + numFrames + ")");
        }
        if ((nativeError = this.sound.context.queueDataAt(time, this.peerToken, this.portHash, channelDataToken, startFrame, numFrames, 8)) < 0) {
            throw new SynthException(nativeError, this.name, startFrame, numFrames);
        }
    }

    public void queueOn(int time, SynthChannelData channelData) throws SynthException {
        this.clear(time);
        if (channelData.getSustainBegin() < 0) {
            if (channelData.getReleaseBegin() < 0) {
                this.queue(time, channelData, 0, channelData.getNumFrames());
            } else {
                this.queue(time, channelData, 0, channelData.getReleaseEnd());
                this.queueLoop(time, channelData, channelData.getReleaseBegin(), channelData.getReleaseSize());
            }
        } else if (channelData.getSustainEnd() > 0) {
            int size = channelData.getSustainBegin();
            if (size > 0) {
                this.queue(time, channelData, 0, size);
            }
            if ((size = channelData.getSustainSize()) > 0) {
                this.queueLoop(time, channelData, channelData.getSustainBegin(), size);
            }
        }
    }

    public void queueOn(SynthChannelData channelData) throws SynthException {
        this.queueOn(this.sound.context.getTickCount(), channelData);
    }

    public void queueOff(int time, SynthChannelData channelData, boolean ifStop) throws SynthException {
        if (channelData.getSustainBegin() >= 0) {
            int relSize = channelData.getReleaseSize();
            if (channelData.getReleaseBegin() < 0) {
                int susEnd = channelData.getSustainEnd();
                int size = channelData.getNumFrames() - susEnd;
                if (size <= 0) {
                    size = 1;
                    susEnd = channelData.getNumFrames() - 1;
                }
                this.queue(time, channelData, susEnd, size, ifStop ? 16 : 0);
            } else if (channelData.getReleaseBegin() > channelData.getSustainEnd()) {
                this.queue(time, channelData, channelData.getSustainEnd(), channelData.getReleaseEnd() - channelData.getSustainEnd());
                if (relSize > 0) {
                    this.queueLoop(time, channelData, channelData.getReleaseBegin(), relSize);
                }
            } else if (relSize > 0) {
                this.queueLoop(time, channelData, channelData.getReleaseBegin(), relSize);
            }
        }
    }

    public void queueOff(int time, SynthChannelData channelData) throws SynthException {
        this.queueOff(time, channelData, false);
    }

    public void queueOff(SynthChannelData channelData) throws SynthException {
        this.queueOff(this.sound.context.getTickCount(), channelData);
    }

    public int getNumFramesMoved(int partIndex) throws SynthException {
        int value = this.sound.context.getPortFrames(this.peerToken, this.portHash, partIndex);
        if (value == -1) {
            throw new SynthException("Error in getNumFramesMoved()");
        }
        return value;
    }

    public int getNumFramesMoved() throws SynthException {
        return this.getNumFramesMoved(0);
    }
}

