/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.SampleWriter_16F1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.SynthSound;
import junit.framework.TestCase;

public class SignalChecker
extends TestCase {
    private SynthContext context;
    private double tolerance = 3.0;

    public SignalChecker(SynthContext context) {
        this.context = context;
    }

    public SignalChecker() {
        this(Synth.getSharedContext());
    }

    public void record(SynthOutput output, short[] image) {
        SynthSample destination = new SynthSample(this.context, image.length);
        SampleWriter_16F1 writer = new SampleWriter_16F1(this.context);
        output.connect(0, writer.input, 0);
        writer.samplePort.queue(destination);
        writer.start();
        int minTicks = (int)(this.context.getTickRate() * (double)image.length / this.context.getFrameRate() + 1.0);
        this.context.sleepForTicks(minTicks);
        destination.read(image);
    }

    public void compare(SynthOutput output, short[] expected) {
        short[] actual = new short[expected.length];
        this.record(output, actual);
        int i = 0;
        while (i < actual.length) {
            SignalChecker.assertEquals("compare actual to expected signal[" + i + "]", (double)expected[i], (double)actual[i], this.tolerance);
            ++i;
        }
    }

    public void dumpSource(short[] image) {
        System.out.println("{");
        int i = 0;
        while (i < image.length) {
            if (i > 0) {
                System.out.print(",");
                if ((i - 1 & 7) == 7) {
                    System.out.println();
                }
            }
            short datum = image[i];
            System.out.print(" " + datum);
            ++i;
        }
        System.out.println("\n}");
    }

    public void checkUnits(SynthSound unit1, SynthSound unit2, short[] image, int imageSize) {
        if (image == null) {
            image = new short[imageSize];
            unit2.start();
            this.record((SynthOutput)unit2.findNamedPort("Output"), image);
            this.dumpSource(image);
        }
        unit1.start();
        this.compare((SynthOutput)unit1.findNamedPort("Output"), image);
        unit1.stop();
        unit2.stop();
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }
}

