/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SampleReader_16F2;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.SynthSampleAIFF;
import com.softsynth.jsyn.SynthSampleWAV;
import java.awt.Button;
import java.awt.Label;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PlayStereoSample {
    SynthSample sample;
    SynthSample sampleZero;
    SampleReader_16F2 samplePlayer;
    LineOut myOut;
    Button startButton;
    Button stopButton;
    Button stopSmoothButton;
    Button testButton;
    Label messageLabel;
    boolean ifApplication = false;
    InputStream stream;
    final int NUM_FRAMES = 64;
    public String fileName = "AlesisSnare.aif";
    double rampUpTime = 0.0;
    double rampDownTime = 0.2;

    public static void main(String[] args) {
        PlayStereoSample app = new PlayStereoSample();
        app.start();
        Synth.sleepForTicks((int)(Synth.getTickRate() * 2.0));
        app.stop();
    }

    public void start() {
        try {
            Synth.startEngine(0);
            Synth.verbosity = 0;
            try {
                this.stream = new FileInputStream(this.fileName);
                switch (SynthSample.getFileType(this.fileName)) {
                    case 1: {
                        this.sample = new SynthSampleAIFF();
                        break;
                    }
                    case 2: {
                        this.sample = new SynthSampleWAV();
                        break;
                    }
                    default: {
                        System.err.println("Unrecognized sample file suffix.");
                    }
                }
                if (this.sample != null) {
                    this.sample.load(this.stream);
                }
                this.stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            this.samplePlayer = new SampleReader_16F2();
            short[] zeros = new short[4];
            this.sampleZero = new SynthSample(zeros.length / 2, 2);
            this.sampleZero.write(zeros);
            this.myOut = new LineOut();
            this.samplePlayer.output.connect(0, this.myOut.input, 0);
            this.samplePlayer.output.connect(0, this.myOut.input, 1);
            this.myOut.start();
            this.samplePlayer.start();
            this.samplePlayer.samplePort.queue(this.sample);
        }
        catch (SynthException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        try {
            this.samplePlayer.delete();
            this.samplePlayer = null;
            this.myOut.delete();
            this.myOut = null;
            Synth.verbosity = 0;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            e.printStackTrace();
        }
    }
}

