/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.install;

import com.softsynth.install.InstallerAppletFrame;
import com.softsynth.install.InstallerGUI;
import com.softsynth.install.PackageDescriptor;
import com.softsynth.install.Uninstaller;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UninstallJSyn
extends Applet {
    InstallerGUI gui;
    Uninstaller uninstaller;
    PackageDescriptor descriptor;
    Vector filePanels;
    Panel fileSelectorPanel;

    public static void main(String[] args) {
        UninstallJSyn applet = new UninstallJSyn();
        InstallerAppletFrame f = new InstallerAppletFrame(applet, "UninstallJSyn Applet Frame");
        f.start();
    }

    private void addTable(Panel filePanel, Hashtable filetable) {
        Enumeration enumer = filetable.elements();
        while (enumer.hasMoreElements()) {
            File file = (File)enumer.nextElement();
            filePanel.add(new FileDeletionPanel(file));
        }
    }

    Component createFileDeletionPanel(PackageDescriptor descriptor) {
        ScrollPane scrollPane = new ScrollPane();
        Panel topLabelPanel = new Panel();
        topLabelPanel.setLayout(new BorderLayout());
        Label label = new Label("Select Files to be Deleted:");
        topLabelPanel.add("North", label);
        this.fileSelectorPanel = new Panel();
        this.fileSelectorPanel.setFont(new Font("Courier", 0, 12));
        this.fileSelectorPanel.setLayout(new GridLayout(0, 1));
        this.updateFileSelector(descriptor, this.fileSelectorPanel);
        scrollPane.add(this.fileSelectorPanel);
        topLabelPanel.add("Center", scrollPane);
        return topLabelPanel;
    }

    private void updateFileSelector(PackageDescriptor descriptor, Panel filePanel) {
        filePanel.removeAll();
        this.filePanels.removeAllElements();
        this.gui.println("Scanning for plugin files. ------------------");
        this.addTable(filePanel, descriptor.nativeLibraryFiles);
        this.addTable(filePanel, descriptor.jarFiles);
    }

    @Override
    public void start() {
        this.filePanels = new Vector();
        this.setLayout(new BorderLayout());
        this.add("North", this.createButtonPanel());
        Panel topLabelPanel = new Panel();
        topLabelPanel.setLayout(new BorderLayout());
        Label label = new Label("Log:");
        topLabelPanel.add("North", label);
        this.gui = new InstallerGUI(this);
        topLabelPanel.add("Center", this.gui);
        this.add("South", topLabelPanel);
        this.uninstaller = new Uninstaller(this.gui);
        this.uninstaller.showProperties();
        try {
            this.descriptor = new PackageDescriptor();
            this.descriptor.addNative("JSynV140");
            this.descriptor.addNative("JSynV141");
            this.descriptor.addNative("JSynV142");
            this.descriptor.addNative("JSynV144");
            this.descriptor.addJar("JSynClasses.jar");
            this.descriptor.addJar("jsyn.jar");
            this.uninstaller.scan(this.descriptor);
            this.add("Center", this.createFileDeletionPanel(this.descriptor));
        }
        catch (IOException e) {
            this.gui.println("Caught " + e);
        }
        this.validate();
        this.repaint();
    }

    private Component createButtonPanel() {
        Panel panel = new Panel();
        panel.add(new Label("Step 1: Select Files"));
        Button selectAllButton = new Button("Select All");
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UninstallJSyn.this.setAllFileSelections(true);
            }
        });
        panel.add(selectAllButton);
        Button deselectAllButton = new Button("Deselect All");
        deselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UninstallJSyn.this.setAllFileSelections(false);
            }
        });
        panel.add(deselectAllButton);
        panel.add(new Label(", Step 2:"));
        Button deleteButton = new Button("DELETE Selected Files");
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UninstallJSyn.this.deleteSelectedFiles();
            }
        });
        panel.add(deleteButton);
        return panel;
    }

    protected void deleteSelectedFiles() {
        Enumeration enumer = this.filePanels.elements();
        while (enumer.hasMoreElements()) {
            FileDeletionPanel filePanel = (FileDeletionPanel)enumer.nextElement();
            if (!filePanel.selector.getState()) continue;
            this.gui.println("Deleting " + filePanel.file.getAbsolutePath());
            try {
                if (filePanel.file.delete()) continue;
                String msg = "\"" + filePanel.file.getAbsolutePath() + "\" locked or in use. Restart browser. Then try again or delete by hand.";
                this.gui.showMessage(msg);
            }
            catch (Exception e1) {
                this.gui.println("Caught " + e1);
            }
        }
        try {
            this.uninstaller.scan(this.descriptor);
        }
        catch (IOException e) {
            this.gui.println("Caught " + e);
        }
        this.updateFileSelector(this.descriptor, this.fileSelectorPanel);
        this.validate();
        this.repaint();
    }

    protected void setAllFileSelections(boolean state) {
        Enumeration enumer = this.filePanels.elements();
        while (enumer.hasMoreElements()) {
            FileDeletionPanel filePanel = (FileDeletionPanel)enumer.nextElement();
            if (!filePanel.file.exists()) continue;
            filePanel.selector.setState(state);
        }
    }

    @Override
    public void stop() {
        this.removeAll();
    }

    class FileDeletionPanel
    extends Panel {
        File file;
        Checkbox selector;

        FileDeletionPanel(File pFile) {
            this.file = pFile;
            this.setLayout(new BorderLayout());
            String boxText = this.file.getAbsolutePath();
            boolean enabled = true;
            if (this.file.exists()) {
                boxText = String.valueOf(boxText) + ", Size = " + this.file.length();
                boxText = String.valueOf(boxText) + ", " + new Date(this.file.lastModified());
            } else {
                boxText = String.valueOf(boxText) + ", DELETED";
                enabled = false;
            }
            UninstallJSyn.this.gui.println(boxText);
            this.selector = new Checkbox(boxText);
            this.selector.setEnabled(enabled);
            this.add("West", this.selector);
            UninstallJSyn.this.filePanels.add(this);
        }
    }
}

