/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.applets.tuning;

import com.softsynth.applets.tuning.SimpleSawNote;
import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.tools.jsyn.CheckForJSyn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TuningResolution
extends JApplet {
    private SimpleSawNote note1;
    private SimpleSawNote note2;
    private LineOut lineOut;
    private AddUnit adder;
    private JTextArea textArea;
    private SynthContext synthContext;
    private DefaultBoundedRangeModel fractionalBits = new DefaultBoundedRangeModel(16, 0, 4, 16);
    private DefaultBoundedRangeModel rootPitch = new DefaultBoundedRangeModel(69, 0, 32, 100);
    private DefaultBoundedRangeModel intervalNumerator = new DefaultBoundedRangeModel(3, 0, 1, 9);
    private DefaultBoundedRangeModel intervalDenominator = new DefaultBoundedRangeModel(2, 0, 1, 9);
    static final double CONCERT_A_FREQUENCY = 440.0;
    static final double CONCERT_A_PITCH = 69.0;

    @Override
    public void start() {
        int jsynStatus = CheckForJSyn.getStatus();
        if (jsynStatus != 0) {
            this.setLayout(new BorderLayout());
            this.add("Center", new CheckForJSyn(this).setupGUI(jsynStatus));
            this.getParent().validate();
            this.getToolkit().sync();
            return;
        }
        this.setupAudio();
        this.setupGUI();
        this.updatePitchValues();
        this.getParent().validate();
        this.getToolkit().sync();
    }

    private void setupAudio() {
        try {
            this.synthContext = new SynthContext();
            this.synthContext.startEngine(0);
            this.note1 = new SimpleSawNote(this.synthContext);
            this.note2 = new SimpleSawNote(this.synthContext);
            this.adder = new AddUnit(this.synthContext);
            this.lineOut = new LineOut(this.synthContext);
            this.note1.output.connect(this.adder.inputB);
            this.note2.output.connect(this.adder.inputA);
            this.adder.output.connect(0, this.lineOut.input, 0);
            this.adder.output.connect(0, this.lineOut.input, 1);
            this.lineOut.start();
            this.adder.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    private void setupGUI() {
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new GridLayout(0, 1));
        northPanel.add(new EZSlider("Bits of Fractional Semitone", this.fractionalBits));
        northPanel.add(new EZSlider("MIDI Pitch of Root", this.rootPitch));
        northPanel.add(new EZSlider("Interval Numerator", this.intervalNumerator));
        northPanel.add(new EZSlider("Interval Denominator", this.intervalDenominator));
        this.add((Component)northPanel, "North");
        this.textArea = new JTextArea("stats");
        this.textArea.setEditable(false);
        this.add((Component)this.textArea, "Center");
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new GridLayout(1, 2));
        southPanel.add(new NoteBox("Root", this.note1));
        southPanel.add(new NoteBox("Interval", this.note2));
        this.add((Component)southPanel, "South");
    }

    public static double convertPitchToFrequency(double pitch) {
        return 440.0 * Math.pow(2.0, (pitch - 69.0) / 12.0);
    }

    public static double convertFrequencyToPitch(double frequency) {
        return 69.0 + 12.0 * Math.log(frequency / 440.0) / Math.log(2.0);
    }

    public void updatePitchValues() {
        String status = "Specified Values\nrootPitch = " + this.rootPitch.getValue() + "\n" + "fractionalBits = " + this.fractionalBits.getValue() + "\n" + "intervalNumerator = " + this.intervalNumerator.getValue() + "\n" + "intervalDenominator = " + this.intervalDenominator.getValue() + "\n";
        double rootFrequency = TuningResolution.convertPitchToFrequency(this.rootPitch.getValue());
        int divisionsPerSemitone = 1 << this.fractionalBits.getValue();
        double offsetRootPitch = (double)this.rootPitch.getValue() + 1.0 / (double)divisionsPerSemitone;
        double errorInCents = 100.0 / (double)divisionsPerSemitone;
        double offsetRootFrequency = TuningResolution.convertPitchToFrequency(offsetRootPitch);
        double intervalFrequency = rootFrequency * (double)this.intervalNumerator.getValue() / (double)this.intervalDenominator.getValue();
        double intervalPitch = TuningResolution.convertFrequencyToPitch(intervalFrequency);
        status = String.valueOf(status) + "Calculated Values\nrootFrequency = " + rootFrequency + "\n" + "divisionsPerSemitone = " + divisionsPerSemitone + "\n" + "errorInCents = " + errorInCents + "\n" + "offsetRootPitch = " + offsetRootPitch + "\n" + "offsetRootFrequency = " + offsetRootFrequency + "\n" + "intervalPitch = " + intervalPitch + "\n" + "intervalFrequency = " + intervalFrequency + "\n";
        this.textArea.setText(status);
        System.out.println(status);
        this.note1.frequency.set(offsetRootFrequency);
        this.note2.frequency.set(intervalFrequency);
    }

    @Override
    public void stop() {
        try {
            this.lineOut.delete();
            this.adder.delete();
            this.removeAll();
            this.synthContext.stopEngine();
            this.synthContext.delete();
        }
        catch (NullPointerException e) {
            System.err.println(e);
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    class EZSlider
    extends JPanel
    implements ChangeListener {
        String text;
        JLabel label;
        JSlider slider;
        DefaultBoundedRangeModel model;

        public EZSlider(String text, DefaultBoundedRangeModel model) {
            this.text = text;
            this.model = model;
            this.setLayout(new GridLayout(1, 2));
            this.label = new JLabel(text, 4);
            this.add(this.label);
            this.slider = new JSlider(model);
            this.add(this.slider);
            this.slider.addChangeListener(this);
            this.slider.setPaintTicks(true);
            int range = model.getMaximum() - model.getMinimum();
            int majorTickSpacing = 5;
            int minorTickSpacing = 1;
            while (range > 20) {
                majorTickSpacing *= 2;
                minorTickSpacing *= 2;
                range /= 2;
            }
            this.slider.setMajorTickSpacing(majorTickSpacing);
            this.slider.setMinorTickSpacing(minorTickSpacing);
            this.updateLabel();
        }

        private void updateLabel() {
            String updated = String.valueOf(this.text) + " = " + this.model.getValue();
            this.label.setText(updated);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateLabel();
            TuningResolution.this.updatePitchValues();
        }
    }

    class NoteBox
    extends JCheckBox {
        final SynthNote note;

        public NoteBox(String text, SimpleSawNote pNote) {
            super(text);
            this.note = pNote;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int time = TuningResolution.this.synthContext.getTickCount();
                    if (NoteBox.this.isSelected()) {
                        NoteBox.this.note.setStage(time, 0);
                    } else {
                        NoteBox.this.note.setStage(time, 1);
                    }
                }
            });
            this.setSelected(true);
        }
    }
}

