/*
 * Decompiled with CFR 0.152.
 */
package com.primalworld.math;

import java.util.HashMap;

public class MathEvaluator {
    protected static Operator[] operators = null;
    private Node node = null;
    private String expression = null;
    private HashMap variables = new HashMap();

    public static void main(String[] args) {
        if (args == null || args.length != 1) {
            System.err.println("Math Expression Evaluator by The-Son LAI Lts@writeme.com C(2001):");
            System.err.println("Usage: java MathEvaluator.main [your math expression]");
            System.exit(0);
        }
        try {
            MathEvaluator m = new MathEvaluator(args[0]);
            System.out.println(m.getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MathEvaluator() {
        this.init();
    }

    public MathEvaluator(String s) {
        this.init();
        this.setExpression(s);
    }

    private void init() {
        if (operators == null) {
            this.initializeOperators();
        }
    }

    public void addVariable(String v, double val) {
        this.addVariable(v, new Double(val));
    }

    public void addVariable(String v, Double val) {
        this.variables.put(v, val);
    }

    public void setExpression(String s) {
        this.expression = s;
    }

    public void reset() {
        this.node = null;
        this.expression = null;
        this.variables = new HashMap();
    }

    public void trace() {
        try {
            this.node = new Node(this.expression);
            this.node.trace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Double getValue() {
        if (this.expression == null) {
            return null;
        }
        try {
            this.node = new Node(this.expression);
            return MathEvaluator.evaluate(this.node);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Double evaluate(Node n) {
        if (n.hasOperator() && n.hasChild()) {
            if (n.getOperator().getType() == 1) {
                n.setValue(MathEvaluator.evaluateExpression(n.getOperator(), MathEvaluator.evaluate(n.getLeft()), null));
            } else if (n.getOperator().getType() == 2) {
                n.setValue(MathEvaluator.evaluateExpression(n.getOperator(), MathEvaluator.evaluate(n.getLeft()), MathEvaluator.evaluate(n.getRight())));
            }
        }
        return n.getValue();
    }

    private static Double evaluateExpression(Operator o, Double f1, Double f2) {
        String op = o.getOperator();
        Double res = null;
        if ("+".equals(op)) {
            res = new Double(f1 + f2);
        } else if ("-".equals(op)) {
            res = new Double(f1 - f2);
        } else if ("*".equals(op)) {
            res = new Double(f1 * f2);
        } else if ("/".equals(op)) {
            res = new Double(f1 / f2);
        } else if ("^".equals(op)) {
            res = new Double(Math.pow(f1, f2));
        } else if ("%".equals(op)) {
            res = new Double(f1 % f2);
        } else if ("&".equals(op)) {
            res = new Double(f1 + f2);
        } else if ("|".equals(op)) {
            res = new Double(f1 + f2);
        } else if ("cos".equals(op)) {
            res = new Double(Math.cos(f1));
        } else if ("sin".equals(op)) {
            res = new Double(Math.sin(f1));
        } else if ("tan".equals(op)) {
            res = new Double(Math.tan(f1));
        } else if ("acos".equals(op)) {
            res = new Double(Math.acos(f1));
        } else if ("asin".equals(op)) {
            res = new Double(Math.asin(f1));
        } else if ("atan".equals(op)) {
            res = new Double(Math.atan(f1));
        } else if ("sqr".equals(op)) {
            res = new Double(f1 * f1);
        } else if ("sqrt".equals(op)) {
            res = new Double(Math.sqrt(f1));
        } else if ("log".equals(op)) {
            res = new Double(Math.log(f1));
        } else if ("min".equals(op)) {
            res = new Double(Math.min(f1, f2));
        } else if ("max".equals(op)) {
            res = new Double(Math.max(f1, f2));
        } else if ("exp".equals(op)) {
            res = new Double(Math.exp(f1));
        } else if ("floor".equals(op)) {
            res = new Double(Math.floor(f1));
        } else if ("ceil".equals(op)) {
            res = new Double(Math.ceil(f1));
        } else if ("abs".equals(op)) {
            res = new Double(Math.abs(f1));
        } else if ("neg".equals(op)) {
            res = new Double(-f1.doubleValue());
        } else if ("rnd".equals(op)) {
            res = new Double(Math.random() * f1);
        }
        return res;
    }

    private void initializeOperators() {
        operators = new Operator[25];
        MathEvaluator.operators[0] = new Operator("+", 2, 0);
        MathEvaluator.operators[1] = new Operator("-", 2, 0);
        MathEvaluator.operators[2] = new Operator("*", 2, 10);
        MathEvaluator.operators[3] = new Operator("/", 2, 10);
        MathEvaluator.operators[4] = new Operator("^", 2, 10);
        MathEvaluator.operators[5] = new Operator("%", 2, 10);
        MathEvaluator.operators[6] = new Operator("&", 2, 0);
        MathEvaluator.operators[7] = new Operator("|", 2, 0);
        MathEvaluator.operators[8] = new Operator("cos", 1, 20);
        MathEvaluator.operators[9] = new Operator("sin", 1, 20);
        MathEvaluator.operators[10] = new Operator("tan", 1, 20);
        MathEvaluator.operators[11] = new Operator("acos", 1, 20);
        MathEvaluator.operators[12] = new Operator("asin", 1, 20);
        MathEvaluator.operators[13] = new Operator("atan", 1, 20);
        MathEvaluator.operators[14] = new Operator("sqrt", 1, 20);
        MathEvaluator.operators[15] = new Operator("sqr", 1, 20);
        MathEvaluator.operators[16] = new Operator("log", 1, 20);
        MathEvaluator.operators[17] = new Operator("min", 2, 0);
        MathEvaluator.operators[18] = new Operator("max", 2, 0);
        MathEvaluator.operators[19] = new Operator("exp", 1, 20);
        MathEvaluator.operators[20] = new Operator("floor", 1, 20);
        MathEvaluator.operators[21] = new Operator("ceil", 1, 20);
        MathEvaluator.operators[22] = new Operator("abs", 1, 20);
        MathEvaluator.operators[23] = new Operator("neg", 1, 20);
        MathEvaluator.operators[24] = new Operator("rnd", 1, 20);
    }

    public Double getVariable(String s) {
        return (Double)this.variables.get(s);
    }

    private Double getDouble(String s) {
        if (s == null) {
            return null;
        }
        Double res = null;
        try {
            res = new Double(Double.parseDouble(s));
        }
        catch (Exception e) {
            return this.getVariable(s);
        }
        return res;
    }

    protected Operator[] getOperators() {
        return operators;
    }

    protected static void _D(String s) {
        System.err.println(s);
    }

    protected class Node {
        public String nString = null;
        public Operator nOperator = null;
        public Node nLeft = null;
        public Node nRight = null;
        public Node nParent = null;
        public int nLevel = 0;
        public Double nValue = null;

        public Node(String s) throws Exception {
            this.init(null, s, 0);
        }

        public Node(Node parent, String s, int level) throws Exception {
            this.init(parent, s, level);
        }

        private void init(Node parent, String s, int level) throws Exception {
            s = this.removeIllegalCharacters(s);
            s = this.removeBrackets(s);
            if (this.checkBrackets(s = this.addZero(s)) != 0) {
                throw new Exception("Wrong number of brackets in [" + s + "]");
            }
            this.nParent = parent;
            this.nString = s;
            this.nValue = MathEvaluator.this.getDouble(s);
            this.nLevel = level;
            int sLength = s.length();
            int inBrackets = 0;
            int startOperator = 0;
            int i = 0;
            while (i < sLength) {
                Operator o;
                if (s.charAt(i) == '(') {
                    ++inBrackets;
                } else if (s.charAt(i) == ')') {
                    --inBrackets;
                } else if (inBrackets == 0 && (o = this.getOperator(this.nString, i)) != null && (this.nOperator == null || this.nOperator.getPriority() >= o.getPriority())) {
                    this.nOperator = o;
                    startOperator = i;
                }
                ++i;
            }
            if (this.nOperator != null) {
                if (startOperator == 0 && this.nOperator.getType() == 1) {
                    if (this.checkBrackets(s.substring(this.nOperator.getOperator().length())) == 0) {
                        this.nLeft = new Node(this, s.substring(this.nOperator.getOperator().length()), this.nLevel + 1);
                        this.nRight = null;
                        return;
                    }
                    throw new Exception("Error during parsing... missing brackets in [" + s + "]");
                }
                if (startOperator > 0 && this.nOperator.getType() == 2) {
                    this.nOperator = this.nOperator;
                    this.nLeft = new Node(this, s.substring(0, startOperator), this.nLevel + 1);
                    this.nRight = new Node(this, s.substring(startOperator + this.nOperator.getOperator().length()), this.nLevel + 1);
                }
            }
        }

        private Operator getOperator(String s, int start) {
            Operator[] operators = MathEvaluator.this.getOperators();
            String temp = s.substring(start);
            temp = this.getNextWord(temp);
            int i = 0;
            while (i < operators.length) {
                if (temp.startsWith(operators[i].getOperator())) {
                    return operators[i];
                }
                ++i;
            }
            return null;
        }

        private String getNextWord(String s) {
            int sLength = s.length();
            int i = 1;
            while (i < sLength) {
                char c = s.charAt(i);
                if (!(c <= 'z' && c >= 'a' || c <= '9' && c >= '0')) {
                    return s.substring(0, i);
                }
                ++i;
            }
            return s;
        }

        protected int checkBrackets(String s) {
            int sLength = s.length();
            int inBracket = 0;
            int i = 0;
            while (i < sLength) {
                if (s.charAt(i) == '(' && inBracket >= 0) {
                    ++inBracket;
                } else if (s.charAt(i) == ')') {
                    --inBracket;
                }
                ++i;
            }
            return inBracket;
        }

        protected String addZero(String s) {
            if (s.startsWith("+") || s.startsWith("-")) {
                int sLength = s.length();
                int i = 0;
                while (i < sLength) {
                    if (this.getOperator(s, i) != null) {
                        return "0" + s;
                    }
                    ++i;
                }
            }
            return s;
        }

        public void trace() {
            String op = this.getOperator() == null ? " " : this.getOperator().getOperator();
            this._D(String.valueOf(op) + " : " + this.getString());
            if (this.hasChild()) {
                if (this.hasLeft()) {
                    this.getLeft().trace();
                }
                if (this.hasRight()) {
                    this.getRight().trace();
                }
            }
        }

        protected boolean hasChild() {
            return this.nLeft != null || this.nRight != null;
        }

        protected boolean hasOperator() {
            return this.nOperator != null;
        }

        protected boolean hasLeft() {
            return this.nLeft != null;
        }

        protected Node getLeft() {
            return this.nLeft;
        }

        protected boolean hasRight() {
            return this.nRight != null;
        }

        protected Node getRight() {
            return this.nRight;
        }

        protected Operator getOperator() {
            return this.nOperator;
        }

        protected int getLevel() {
            return this.nLevel;
        }

        protected Double getValue() {
            return this.nValue;
        }

        protected void setValue(Double f) {
            this.nValue = f;
        }

        protected String getString() {
            return this.nString;
        }

        public String removeBrackets(String s) {
            String res = s;
            if (s.length() > 2 && res.startsWith("(") && res.endsWith(")") && this.checkBrackets(s.substring(1, s.length() - 1)) == 0) {
                res = res.substring(1, res.length() - 1);
            }
            if (res != s) {
                return this.removeBrackets(res);
            }
            return res;
        }

        public String removeIllegalCharacters(String s) {
            char[] illegalCharacters = new char[]{' '};
            String res = s;
            int j = 0;
            while (j < illegalCharacters.length) {
                int i = res.lastIndexOf(illegalCharacters[j], res.length());
                while (i != -1) {
                    String temp = res;
                    res = temp.substring(0, i);
                    res = String.valueOf(res) + temp.substring(i + 1);
                    i = res.lastIndexOf(illegalCharacters[j], s.length());
                }
                ++j;
            }
            return res;
        }

        protected void _D(String s) {
            String nbSpaces = "";
            int i = 0;
            while (i < this.nLevel) {
                nbSpaces = String.valueOf(nbSpaces) + "  ";
                ++i;
            }
            System.out.println(String.valueOf(nbSpaces) + "|" + s);
        }
    }

    protected class Operator {
        private String op;
        private int type;
        private int priority;

        public Operator(String o, int t, int p) {
            this.op = o;
            this.type = t;
            this.priority = p;
        }

        public String getOperator() {
            return this.op;
        }

        public void setOperator(String o) {
            this.op = o;
        }

        public int getType() {
            return this.type;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

