/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.softsynth.math.FourierMath;
import junit.framework.TestCase;

public class TestFFT
extends TestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void checkSingleSine(int size, int bin) {
        double[] ar = new double[size];
        double[] ai = new double[size];
        double[] magnitudes = new double[size];
        double amplitude = 1.0;
        this.addSineWave(size, bin, ar, amplitude);
        FourierMath.transform(1, size, ar, ai);
        FourierMath.calculateMagnitudes(ar, ai, magnitudes);
        TestFFT.assertTrue(magnitudes[bin - 1] < 0.001);
        TestFFT.assertTrue(magnitudes[bin] > 0.5);
        TestFFT.assertTrue(magnitudes[bin + 1] < 0.001);
    }

    private void addSineWave(int size, int bin, double[] ar, double amplitude) {
        double phase = 0.0;
        double phaseIncrement = Math.PI * 2 * (double)bin / (double)size;
        int i = 0;
        while (i < size) {
            int n = i++;
            ar[n] = ar[n] + Math.sin(phase) * amplitude;
            phase += phaseIncrement;
        }
    }

    public void testSingles() {
        this.checkSingleSine(32, 1);
        this.checkSingleSine(32, 2);
        this.checkSingleSine(64, 5);
        this.checkSingleSine(256, 3);
    }

    public void checkInverseFFT(int size, int bin) {
        double[] ar1 = new double[size];
        double[] ai1 = new double[size];
        double[] ar2 = new double[size];
        double[] ai2 = new double[size];
        double amplitude = 1.0;
        this.addSineWave(size, bin, ar1, amplitude);
        System.arraycopy(ar1, 0, ar2, 0, size);
        System.arraycopy(ai1, 0, ai2, 0, size);
        FourierMath.transform(1, size, ar1, ai1);
        FourierMath.transform(-1, size, ar1, ai1);
        int i = 0;
        while (i < size) {
            TestFFT.assertEquals(ar2[i], ar1[i], 1.0E-5);
            TestFFT.assertEquals(ai2[i], ai1[i], 1.0E-5);
            ++i;
        }
    }

    public void testInverse() {
        this.checkInverseFFT(32, 1);
        this.checkInverseFFT(32, 2);
        this.checkInverseFFT(128, 17);
        this.checkInverseFFT(512, 23);
    }
}

