/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.data.FloatSample;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.util.AutoCorrelator;
import com.jsynx.inprogress.SequentialDataView;
import java.awt.BorderLayout;
import java.util.Random;
import javax.swing.JApplet;

public class DebugAutoCorrelator
extends JApplet {
    private static final long serialVersionUID = -831590388347137926L;
    private SequentialDataView view;
    private Random randomizer;
    private Random random;

    public static void main(String[] args) {
        DebugAutoCorrelator applet = new DebugAutoCorrelator();
        JAppletFrame frame = new JAppletFrame("AutoCorrelator", applet);
        frame.setSize(640, 500);
        frame.setVisible(true);
        frame.test();
        frame.validate();
    }

    private void setupGUI() {
        this.setLayout(new BorderLayout());
        this.view = new SequentialDataView();
        this.add("Center", this.view);
        this.validate();
    }

    public AutoCorrelator analyzeThis(double period, double[] partials, double noiseLevel) {
        int resultCount = 0;
        double[] phases = new double[partials.length];
        AutoCorrelator auto = new AutoCorrelator(2400);
        double phaseIncrement = Math.PI * 2 / period;
        while (resultCount < 4) {
            double value = 0.0;
            int j = 0;
            while (j < partials.length) {
                value += Math.sin(phases[j]) * partials[j];
                value += (this.random.nextDouble() * 2.0 - 1.0) * noiseLevel;
                int n = j;
                phases[n] = phases[n] + (double)(j + 1) * phaseIncrement;
                ++j;
            }
            if (!auto.addSample(value)) continue;
            ++resultCount;
        }
        return auto;
    }

    public void view() {
        double noiseLevel = 0.9;
        double[] partials = new double[]{0.7, 0.8, 0.6, 0.4, 0.2};
        double period = 243.6;
        AutoCorrelator auto = this.analyzeThis(period, partials, noiseLevel);
        double measured = auto.getPeriod();
        System.out.println("expected = " + period + ", measured = " + measured);
        System.out.println("confidence = " + auto.getConfidence());
        float[] diffs = auto.getDiffs();
        FloatSample sample = new FloatSample(diffs);
        this.setupGUI();
        this.view.setData(sample);
        this.view.addMarker("Period", (int)Math.round(measured));
        System.out.println("min = " + this.view.getMinValue() + ", max = " + this.view.getMaxValue());
    }

    @Override
    public void start() {
        this.random = new Random(4158464370L);
        this.measureSubOctaveImmunity();
        this.view();
    }

    private void measureSubOctaveImmunity() {
        double[] periods = new double[]{34.7, 89.4, 243.6};
        int ip = 0;
        while (ip < periods.length) {
            double noiseLevel = 0.0;
            while (noiseLevel < 1.01) {
                this.measureSubOctaveImmunity(periods[ip], noiseLevel);
                noiseLevel += 0.1;
            }
            ++ip;
        }
    }

    private void measureSubOctaveImmunity(double period, double noiseLevel) {
        System.out.printf("suboctave test period = %5.1f, noise = %4.1f", period, noiseLevel);
        double[] partials = new double[]{1.0, 0.8, 0.6, 0.4, 0.2};
        double fundamentalStrength = 1.0;
        while (fundamentalStrength > 0.01) {
            partials[0] = fundamentalStrength;
            AutoCorrelator auto = this.analyzeThis(period, partials, noiseLevel);
            double measured = auto.getPeriod();
            double error = Math.abs(measured - period) / period;
            if (error > 0.1) {
                System.out.printf(", FAIL at |f0| = %5.3f\n", fundamentalStrength);
                return;
            }
            fundamentalStrength *= 0.95;
        }
        System.out.printf(", pass\n", new Object[0]);
    }

    @Override
    public void stop() {
    }
}

