/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.tutorial;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view11x.ExponentialPortFader;
import com.softsynth.jsyn.view11x.LabelledFader;
import com.softsynth.jsyn.view11x.PortFader;
import com.softsynth.jsyn.view11x.SynthScope;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;

public class TUT_SineFreq
extends Applet {
    SineOscillator sineOsc;
    LineOut lineOut;
    LabelledFader freqFader;
    LabelledFader ampFader;
    SynthScope scope;

    public static void main(String[] args) {
        TUT_SineFreq applet = new TUT_SineFreq();
        AppletFrame frame = new AppletFrame("Test JSyn", applet);
        frame.resize(500, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        try {
            Synth.startEngine(0);
            this.sineOsc = new SineOscillator();
            this.lineOut = new LineOut();
            this.sineOsc.output.connect(0, this.lineOut.input, 0);
            this.sineOsc.output.connect(0, this.lineOut.input, 1);
            this.sineOsc.amplitude.set(0.0);
            this.lineOut.start();
            this.sineOsc.start();
            this.scope = new SynthScope();
            this.add("Center", this.scope);
            this.scope.createProbe(this.sineOsc.output, "Output", Color.yellow);
            this.scope.finish();
            this.scope.hideControls();
            Panel faderPanel = new Panel();
            faderPanel.setLayout(new GridLayout(0, 1));
            this.add("North", faderPanel);
            this.freqFader = new ExponentialPortFader(this.sineOsc.frequency, "Frequency", 440.0, 50.0, 2000.0);
            faderPanel.add(this.freqFader);
            this.ampFader = new PortFader(this.sineOsc.amplitude, "Amplitude", 0.0, 0.0, 1.0);
            faderPanel.add(this.ampFader);
            this.getParent().validate();
            this.getToolkit().sync();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.sineOsc.delete();
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            System.out.println("Caught " + e);
        }
    }
}

