/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.tutorial;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;

public class TUT_HearEnv
extends Applet {
    SineOscillator sineOsc;
    SynthEnvelope envData;
    EnvelopePlayer envPlayer;
    LineOut lineOut;
    Button queueButton;
    Button clearButton;

    public static void main(String[] args) {
        TUT_HearEnv applet = new TUT_HearEnv();
        AppletFrame frame = new AppletFrame("Hear Envelope", applet);
        frame.resize(300, 100);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        try {
            Synth.startEngine(0);
            this.sineOsc = new SineOscillator();
            this.envPlayer = new EnvelopePlayer();
            this.lineOut = new LineOut();
            this.sineOsc.output.connect(0, this.lineOut.input, 0);
            this.sineOsc.output.connect(0, this.lineOut.input, 1);
            this.envPlayer.output.connect(this.sineOsc.amplitude);
            double[] data = new double[]{0.02, 1.0, 0.3, 0.5, 1.2, 0.0};
            this.envData = new SynthEnvelope(data);
            this.queueButton = new Button("Queue Envelope");
            this.add(this.queueButton);
            this.clearButton = new Button("Clear Queue");
            this.add(this.clearButton);
            this.lineOut.start();
            this.sineOsc.start();
            this.envPlayer.start();
            this.getParent().validate();
            this.getToolkit().sync();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (evt.target == this.queueButton) {
            this.envPlayer.envelopePort.queue(this.envData);
            return true;
        }
        if (evt.target == this.clearButton) {
            this.envPlayer.envelopePort.clear();
            return true;
        }
        return false;
    }
}

