/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.instruments.SubtractiveSynthVoice;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.VoiceAllocator;
import com.softsynth.shared.time.TimeStamp;

public class PlayChords {
    private static final int MAX_VOICES = 8;
    private Synthesizer synth;
    private VoiceAllocator allocator;
    private LineOut lineOut;
    private double advance = 0.2;
    private double secondsPerBeat = 0.6;
    private double dutyCycle = 0.8;
    private double measure = this.secondsPerBeat * 4.0;
    private UnitVoice[] voices;

    private void test() {
        this.synth = JSyn.createSynthesizer();
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.voices = new UnitVoice[8];
        int i = 0;
        while (i < 8) {
            SubtractiveSynthVoice voice = new SubtractiveSynthVoice();
            this.synth.add(voice);
            voice.getOutput().connect(0, this.lineOut.input, 0);
            voice.getOutput().connect(0, this.lineOut.input, 1);
            this.voices[i] = voice;
            ++i;
        }
        this.allocator = new VoiceAllocator(this.voices);
        this.synth.start();
        this.lineOut.start();
        double timeNow = this.synth.getCurrentTime();
        double time = timeNow + 1.0;
        try {
            int tonic = 48;
            int i2 = 0;
            while (i2 < 4) {
                this.playMajorMeasure1(time, tonic);
                this.catchUp(time += this.measure);
                this.playMajorMeasure1(time, tonic + 4);
                this.catchUp(time += this.measure);
                this.playMajorMeasure1(time, tonic + 7);
                this.catchUp(time += this.measure);
                this.playMinorMeasure1(time, tonic + 2);
                this.catchUp(time += this.measure);
                ++i2;
            }
            this.catchUp(time += this.secondsPerBeat);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.synth.stop();
    }

    private void playMinorMeasure1(double time, int base) throws InterruptedException {
        int p1 = base;
        int p2 = base + 3;
        int p3 = base + 7;
        this.playChord1(time, p1, p2, p3);
        this.playNoodle1(time, p1 + 24, p2 + 24, p3 + 24);
    }

    private void playMajorMeasure1(double time, int base) throws InterruptedException {
        int p1 = base;
        int p2 = base + 4;
        int p3 = base + 7;
        this.playChord1(time, p1, p2, p3);
        this.playNoodle1(time, p1 + 24, p2 + 24, p3 + 24);
    }

    private void playNoodle1(double time, int p1, int p2, int p3) {
        double secondsPerNote = this.secondsPerBeat * 0.5;
        int i = 0;
        while (i < 8) {
            int p = this.pickFromThree(p1, p2, p3);
            this.noteOn(time, p);
            this.noteOff(time + this.dutyCycle * secondsPerNote, p);
            time += secondsPerNote;
            ++i;
        }
    }

    private int pickFromThree(int p1, int p2, int p3) {
        int r = (int)(Math.random() * 3.0);
        if (r < 1) {
            return p1;
        }
        if (r < 2) {
            return p2;
        }
        return p3;
    }

    private void playChord1(double time, int p1, int p2, int p3) throws InterruptedException {
        double dur = this.dutyCycle * this.secondsPerBeat;
        this.playTriad(time, dur, p1, p2, p3);
        this.playTriad(time += this.secondsPerBeat, dur, p1, p2, p3);
        this.playTriad(time += this.secondsPerBeat, dur * 0.25, p1, p2, p3);
        this.playTriad(time += this.secondsPerBeat * 0.25, dur * 0.25, p1, p2, p3);
        this.playTriad(time += this.secondsPerBeat * 0.75, dur, p1, p2, p3);
        time += this.secondsPerBeat;
    }

    private void playTriad(double time, double dur, int p1, int p2, int p3) throws InterruptedException {
        this.noteOn(time, p1);
        this.noteOn(time, p2);
        this.noteOn(time, p3);
        double offTime = time + dur;
        this.noteOff(offTime, p1);
        this.noteOff(offTime, p2);
        this.noteOff(offTime, p3);
    }

    private void catchUp(double time) throws InterruptedException {
        this.synth.sleepUntil(time - this.advance);
    }

    private void noteOff(double time, int noteNumber) {
        this.allocator.noteOff(noteNumber, new TimeStamp(time));
    }

    private void noteOn(double time, int noteNumber) {
        double frequency = this.convertPitchToFrequency(noteNumber);
        double amplitude = 0.2;
        TimeStamp timeStamp = new TimeStamp(time);
        this.allocator.noteOn(noteNumber, frequency, amplitude, timeStamp);
    }

    double convertPitchToFrequency(double pitch) {
        double concertA = 440.0;
        return 440.0 * Math.pow(2.0, (pitch - 69.0) * 0.08333333333333333);
    }

    public static void main(String[] args) {
        new PlayChords().test();
    }
}

