/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.engine;

import com.jsyn.data.FloatSample;
import com.jsyn.util.SampleLoader;
import com.jsyn.util.WaveFileWriter;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.UnsupportedAudioFileException;
import junit.framework.TestCase;

public class TestWaveFileReadWrite
extends TestCase {
    public void checkWriteReadWave(int numChannels, float[] data) throws IOException, UnsupportedAudioFileException {
        File temp = File.createTempFile("test_wave", ".wav");
        temp.deleteOnExit();
        System.out.println("Creating wave file " + temp);
        WaveFileWriter writer = new WaveFileWriter(temp);
        writer.setFrameRate(44100);
        writer.setSamplesPerFrame(numChannels);
        writer.setBitsPerSample(16);
        int i = 0;
        while (i < data.length) {
            writer.write(data[i]);
            ++i;
        }
        writer.close();
        FloatSample sample = SampleLoader.loadFloatSample(temp);
        TestWaveFileReadWrite.assertEquals("stereo", numChannels, sample.getChannelsPerFrame());
        TestWaveFileReadWrite.assertEquals("frame rate", (Object)44100.0, (Object)sample.getFrameRate());
        int i2 = 0;
        while (i2 < data.length) {
            float v = data[i2];
            if ((double)v > 1.0) {
                v = 1.0f;
            } else if ((double)v < -1.0) {
                v = -1.0f;
            }
            TestWaveFileReadWrite.assertEquals("sample data", (double)v, sample.readDouble(i2), 1.0E-4);
            ++i2;
        }
    }

    public void testRamp() throws IOException, UnsupportedAudioFileException {
        float[] data = new float[200];
        int i = 0;
        while (i < data.length) {
            data[i] = (float)i / 1000.0f;
            ++i;
        }
        this.checkWriteReadWave(2, data);
    }

    public void testClippedSine() throws IOException, UnsupportedAudioFileException {
        float[] data = new float[200];
        int i = 0;
        while (i < data.length) {
            double phase = (double)i * Math.PI * 2.0 / 100.0;
            data[i] = (float)(1.3 * Math.sin(phase));
            ++i;
        }
        this.checkWriteReadWave(2, data);
    }

    public void testArguments() throws IOException {
        File temp = File.createTempFile("test_wave", ".wav");
        temp.deleteOnExit();
        System.out.println("Creating wave file " + temp);
        WaveFileWriter writer = new WaveFileWriter(temp);
        writer.setBitsPerSample(16);
        TestWaveFileReadWrite.assertEquals("bitsPerSample", 16, writer.getBitsPerSample());
        writer.setBitsPerSample(24);
        TestWaveFileReadWrite.assertEquals("bitsPerSample", 24, writer.getBitsPerSample());
        boolean caughtIt = false;
        try {
            writer.setBitsPerSample(17);
            TestWaveFileReadWrite.assertTrue("tried setting illegal value", false);
        }
        catch (IllegalArgumentException e) {
            caughtIt = true;
        }
        TestWaveFileReadWrite.assertTrue("17 generated exception", caughtIt);
        writer.close();
    }
}

