/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.engine;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.PitchDetector;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.ZeroCrossingCounter;
import junit.framework.TestCase;

public class TestEngine
extends TestCase {
    public void testInitialization() {
        int DEFAULT_FRAME_RATE = 44100;
        SynthesisEngine synthesisEngine = new SynthesisEngine();
        TestEngine.assertEquals("frameCount zero before starting", 0L, synthesisEngine.getFrameCount());
        TestEngine.assertEquals("default frameRate", 44100, synthesisEngine.getFrameRate());
        TestEngine.assertEquals("default pullData", true, synthesisEngine.isPullDataEnabled());
    }

    public void checkPullData(boolean pullData) {
        SynthesisEngine synthesisEngine = new SynthesisEngine();
        TestEngine.assertEquals("default realTime", true, synthesisEngine.isRealTime());
        synthesisEngine.setRealTime(false);
        TestEngine.assertEquals("default pullData", true, synthesisEngine.isPullDataEnabled());
        synthesisEngine.setPullDataEnabled(pullData);
        SineOscillator sineOscillator = new SineOscillator();
        synthesisEngine.add(sineOscillator);
        LineOut lineOut = new LineOut();
        synthesisEngine.add(lineOut);
        sineOscillator.output.connect(0, lineOut.input, 0);
        TestEngine.assertEquals("initial sine value", (Object)0.0, (Object)sineOscillator.output.getValue());
        synthesisEngine.start();
        if (!pullData) {
            sineOscillator.start();
        }
        lineOut.start();
        synthesisEngine.generateNextBuffer();
        synthesisEngine.generateNextBuffer();
        double value = sineOscillator.output.getValue();
        TestEngine.assertTrue("sine value after generation = " + value, value > 0.0);
    }

    public void testPullDataFalse() {
        this.checkPullData(false);
    }

    public void testPullDataTrue() {
        this.checkPullData(true);
    }

    public void testMixedAdding() {
        boolean gotCaught = false;
        SynthesisEngine synthesisEngine1 = new SynthesisEngine();
        synthesisEngine1.setRealTime(false);
        synthesisEngine1.setPullDataEnabled(true);
        SynthesisEngine synthesisEngine2 = new SynthesisEngine();
        synthesisEngine2.setRealTime(false);
        synthesisEngine2.setPullDataEnabled(true);
        SineOscillator sineOscillator = new SineOscillator();
        LineOut lineOut = new LineOut();
        synthesisEngine1.add(lineOut);
        synthesisEngine2.add(sineOscillator);
        try {
            sineOscillator.output.connect(0, lineOut.input, 0);
        }
        catch (RuntimeException e) {
            gotCaught = true;
            TestEngine.assertTrue("informative MPE message", e.getMessage().contains("different synths"));
        }
        TestEngine.assertTrue("caught NPE caused by forgetting synth.add", gotCaught);
    }

    public void testNotAdding() {
        SynthesisEngine synthesisEngine = new SynthesisEngine();
        synthesisEngine.setRealTime(false);
        synthesisEngine.setPullDataEnabled(true);
        SineOscillator sineOscillator = new SineOscillator();
        LineOut lineOut = new LineOut();
        sineOscillator.output.connect(0, lineOut.input, 0);
        synthesisEngine.add(lineOut);
        TestEngine.assertEquals("initial sine value", (Object)0.0, (Object)sineOscillator.output.getValue());
        synthesisEngine.start();
        lineOut.start();
        boolean gotCaught = false;
        try {
            synthesisEngine.generateNextBuffer();
            synthesisEngine.generateNextBuffer();
        }
        catch (NullPointerException e) {
            gotCaught = true;
            TestEngine.assertTrue("informative MPE message", e.getMessage().contains("forgot to add"));
        }
        TestEngine.assertTrue("caught NPE caused by forgetting synth.add", gotCaught);
    }

    public void testMultipleStarts() throws InterruptedException {
        int[] rates;
        SynthesisEngine synth = new SynthesisEngine();
        SineOscillator osc = new SineOscillator();
        ZeroCrossingCounter counter = new ZeroCrossingCounter();
        PitchDetector pitchDetector = new PitchDetector();
        LineOut lineOut = new LineOut();
        synth.add(osc);
        synth.add(counter);
        synth.add(lineOut);
        synth.add(pitchDetector);
        osc.output.connect(counter.input);
        osc.output.connect(pitchDetector.input);
        counter.output.connect(0, lineOut.input, 0);
        TestEngine.assertEquals("initial count", 0L, counter.getCount());
        int[] nArray = rates = new int[]{32000, 48000, 44100, 22050};
        int n = rates.length;
        int n2 = 0;
        while (n2 < n) {
            int rate = nArray[n2];
            synth.start(rate);
            lineOut.start();
            pitchDetector.start();
            double time = synth.getCurrentTime();
            double interval = 1.0;
            long previousFrameCount = counter.getCount();
            synth.sleepUntil(time += interval);
            double frequencyMeasured = pitchDetector.frequency.get();
            double confidenceMeasured = pitchDetector.confidence.get();
            double oscFreq = osc.frequency.get();
            String msg = "freq at " + rate + " Hz";
            System.out.println(msg);
            TestEngine.assertEquals(msg, oscFreq, frequencyMeasured, oscFreq * 0.1);
            TestEngine.assertEquals("pitch confidence", 0.9, confidenceMeasured, 0.1);
            double expectedCount = interval * oscFreq;
            double framesMeasured = counter.getCount() - previousFrameCount;
            msg = "count at " + rate + " Hz";
            System.out.println(msg);
            TestEngine.assertEquals(msg, expectedCount, framesMeasured, expectedCount * 0.1);
            synth.stop();
            ++n2;
        }
    }
}

